/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.AbstractDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadingDifferencesFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            boolean ret = false;
            if (input instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)input;
                EObject data = treeNode.getData();
                TreeNode parent = treeNode.getParent();
                EObject parentData = parent != null ? parent.getData() : null;
                if (parentData instanceof Diff && !(parentData instanceof ResourceAttachmentChange) && !EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.MOVE).apply((Object)((Diff)parentData)) && data instanceof Diff) {
                    Iterator eAllDataContents = Iterators.transform((Iterator)treeNode.eAllContents(), IDifferenceGroup.TREE_NODE_DATA);
                    return CASCADING_DIFF.apply((Object)data) && !Iterators.any((Iterator)eAllDataContents, (Predicate)Predicates.not((Predicate)CASCADING_DIFF));
                }
            }
            return ret;
        }
    };
    private static final Predicate<EObject> IS_NON_CONFLICTUAL_DIFF = new Predicate<EObject>(){

        public boolean apply(EObject eObject) {
            if (eObject instanceof Diff) {
                Conflict conflict = ((Diff)eObject).getConflict();
                return conflict == null || ConflictKind.PSEUDO == conflict.getKind();
            }
            return false;
        }
    };
    private static final Predicate<EObject> CASCADING_DIFF = Predicates.and(IS_NON_CONFLICTUAL_DIFF, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class)));

    @Override
    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }
}

