/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.extension;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractRegistryEventListener
implements IRegistryEventListener {
    private final String namespace;
    private final String extensionPointID;
    private final ILog log;

    public AbstractRegistryEventListener(String namespace, String extensionPointID, ILog log) {
        this.namespace = namespace;
        this.extensionPointID = extensionPointID;
        this.log = log;
    }

    public void readRegistry(IExtensionRegistry extensionRegistry) {
        IExtensionPoint point = extensionRegistry.getExtensionPoint(this.namespace, this.extensionPointID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.internalReadElement(elements[i], Action.ADD);
                ++i;
            }
        }
    }

    protected boolean readElement(IConfigurationElement element, Action action) {
        boolean ret;
        if (this.validateExtensionElement(element)) {
            switch (action) {
                case ADD: {
                    ret = this.addedValid(element);
                    break;
                }
                case REMOVE: {
                    ret = this.removedValid(element);
                    break;
                }
                default: {
                    ret = false;
                    break;
                }
            }
        } else {
            ret = false;
        }
        return ret;
    }

    protected abstract boolean validateExtensionElement(IConfigurationElement var1);

    protected abstract boolean addedValid(IConfigurationElement var1);

    protected abstract boolean removedValid(IConfigurationElement var1);

    private void internalReadElement(IConfigurationElement element, Action action) {
        boolean recognized = this.readElement(element, action);
        if (recognized) {
            IConfigurationElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.internalReadElement(children[i], action);
                ++i;
            }
        }
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.log(4, element, "The required attribute '" + attributeName + "' not defined");
    }

    protected void log(int severity, IConfigurationElement element, String message) {
        this.log.log((IStatus)new Status(severity, element.getDeclaringExtension().getContributor().getName(), message));
    }

    protected void log(IConfigurationElement element, Throwable t) {
        this.log.log((IStatus)new Status(4, element.getDeclaringExtension().getContributor().getName(), t.getMessage(), t));
    }

    protected void log(IConfigurationElement element, String errorMessage, Throwable cause) {
        this.log.log((IStatus)new Status(4, element.getDeclaringExtension().getContributor().getName(), errorMessage, cause));
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointID)) {
                IConfigurationElement[] configurationElement = extension.getConfigurationElements();
                int j = 0;
                while (j < configurationElement.length) {
                    this.internalReadElement(configurationElement[j], Action.ADD);
                    ++j;
                }
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointID)) {
                IConfigurationElement[] configurationElement = extension.getConfigurationElements();
                int j = 0;
                while (j < configurationElement.length) {
                    this.internalReadElement(configurationElement[j], Action.REMOVE);
                    ++j;
                }
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Action {
        ADD,
        REMOVE;

    }
}

