/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMerger
implements IMerger {
    private int ranking;
    private IMerger.Registry registry;

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public IMerger.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(IMerger.Registry registry) {
        if (this.registry != null && registry != null) {
            throw new IllegalStateException("The registry has to be set only once.");
        }
        this.registry = registry;
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        target.setState(DifferenceState.MERGED);
        if (target.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(target, false, monitor);
            this.handleImplies(target, false, monitor);
        } else {
            this.mergeRequiredBy(target, false, monitor);
            this.handleImpliedBy(target, false, monitor);
        }
        for (Diff refining : target.getRefinedBy()) {
            this.mergeDiff(refining, false, monitor);
        }
        boolean hasToBeMerged = true;
        if (target.getEquivalence() != null) {
            hasToBeMerged = this.handleEquivalences(target, false, monitor);
        }
        if (hasToBeMerged) {
            if (target.getSource() == DifferenceSource.LEFT) {
                this.accept(target, false);
            } else {
                this.reject(target, false);
            }
        }
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        target.setState(DifferenceState.MERGED);
        if (target.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(target, true, monitor);
            this.handleImpliedBy(target, true, monitor);
        } else {
            this.mergeRequires(target, true, monitor);
            this.handleImplies(target, true, monitor);
        }
        for (Diff refining : target.getRefinedBy()) {
            this.mergeDiff(refining, true, monitor);
        }
        boolean hasToBeMerged = true;
        if (target.getEquivalence() != null) {
            hasToBeMerged = this.handleEquivalences(target, true, monitor);
        }
        if (hasToBeMerged) {
            if (target.getSource() == DifferenceSource.LEFT) {
                this.reject(target, true);
            } else {
                this.accept(target, true);
            }
        }
    }

    protected void accept(Diff diff, boolean rightToLeft) {
    }

    protected void reject(Diff diff, boolean rightToLeft) {
    }

    protected void mergeRequiredBy(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequiredBy()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    protected void handleImplies(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff implied : diff.getImplies()) {
            implied.setState(DifferenceState.MERGED);
            this.handleImplies(implied, rightToLeft, monitor);
        }
    }

    protected void handleImpliedBy(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff impliedBy : diff.getImpliedBy()) {
            impliedBy.setState(DifferenceState.MERGED);
            this.handleImpliedBy(impliedBy, rightToLeft, monitor);
        }
    }

    protected void mergeRequires(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequires()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    protected void mergeDiff(Diff diff, boolean rightToLeft, Monitor monitor) {
        if (rightToLeft) {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyRightToLeft(diff, monitor);
        } else {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyLeftToRight(diff, monitor);
        }
    }

    protected boolean handleEquivalences(Diff diff, boolean rightToLeft, Monitor monitor) {
        boolean continueMerge = true;
        for (Diff equivalent : diff.getEquivalence().getDifferences()) {
            if (diff instanceof ReferenceChange && equivalent instanceof ReferenceChange) {
                EReference reference = ((ReferenceChange)diff).getReference();
                EReference equivalentReference = ((ReferenceChange)equivalent).getReference();
                if (reference.getEOpposite() == equivalentReference && equivalent.getState() == DifferenceState.UNRESOLVED) {
                    boolean mergeEquivalence;
                    boolean bl = mergeEquivalence = !reference.isMany() && ((ReferenceChange)equivalent).getReference().isMany();
                    if (mergeEquivalence) {
                        this.mergeDiff(equivalent, rightToLeft, monitor);
                        continueMerge = false;
                    }
                }
            }
            continueMerge = rightToLeft ? (diff.getSource() == DifferenceSource.LEFT ? continueMerge && !Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(diff.getRequiredBy())) : continueMerge && !Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(diff.getRequires()))) : (diff.getSource() == DifferenceSource.LEFT ? continueMerge && !Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(diff.getRequires())) : continueMerge && !Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(diff.getRequiredBy())));
            equivalent.setState(DifferenceState.MERGED);
        }
        return continueMerge;
    }

    protected EObject createCopy(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected <E> void addAt(List<E> list, E value, int insertionIndex) {
        if (list instanceof InternalEList) {
            if (insertionIndex < 0 || insertionIndex > list.size()) {
                ((InternalEList)list).addUnique(value);
            } else {
                ((InternalEList)list).addUnique(insertionIndex, value);
            }
        } else if (insertionIndex < 0 || insertionIndex > list.size()) {
            list.add(value);
        } else {
            list.add(insertionIndex, value);
        }
    }
}

