/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.rcp.internal.match.DefaultRCPMatchEngineFactory;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.AbstractConfigurationUI;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.IConfigurationUIFactory;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.DataHolder;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.impl.InteractiveUIContent;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnginesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final Map<String, InteractiveUIContent> interactiveUis = new HashMap<String, InteractiveUIContent>();
    private final DataHolder<IDiffEngine> diffEngineData = new DataHolder();
    private final DataHolder<IEquiEngine> equiEngineData = new DataHolder();
    private final DataHolder<IReqEngine> reqEngineData = new DataHolder();
    private final DataHolder<IConflictDetector> conflictsDetectorData = new DataHolder();
    private final DataHolder<IMatchEngine.Factory> matchEnginesData = new DataHolder();

    public EnginesPreferencePage() {
    }

    public EnginesPreferencePage(String title) {
        super(title);
    }

    public EnginesPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        TabFolder tabFolder = new TabFolder(container, 0);
        this.createMatchEngineTab(tabFolder);
        this.createDiffEngineTab(tabFolder);
        this.createEquiEngineTab(tabFolder);
        this.createReqEngineTab(tabFolder);
        this.createConflictDetectorTab(tabFolder);
        return container;
    }

    private <T> InteractiveUIContent createEngineUIBuilder(IItemRegistry<T> registry, String enginePreferenceKey, IEclipsePreferences pref, Composite tabComposite, DataHolder<T> dataHolder) {
        IItemDescriptor defaultEngine = ItemUtil.getDefaultItemDescriptor(registry, (String)enginePreferenceKey, (IEclipsePreferences)pref);
        InteractiveUIContent.InteractiveUIBuilder<T> uiBuilder = new InteractiveUIContent.InteractiveUIBuilder<T>(tabComposite, registry);
        uiBuilder.setSimple(true).setDefaultCheck(Collections.singleton(defaultEngine)).setDefaultSelection(defaultEngine).setHoldingData(dataHolder);
        return uiBuilder.build();
    }

    private void createConflictDetectorTab(TabFolder tabFolder) {
        IItemRegistry conflictDetectorDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.conflictDetector.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.conflictDetectorIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(conflictDetectorDescriptorRegistry, "org.eclipse.emf.compare.preference.conflict.detector", EMFCompareRCPPlugin.getDefault().getEMFComparePreferences(), tabComposite, this.conflictsDetectorData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.conflict.detector", interactiveContent);
    }

    private void createReqEngineTab(TabFolder tabFolder) {
        IItemRegistry reqEngineDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.requirementEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.reqEngineIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(reqEngineDescriptorRegistry, "org.eclipse.emf.compare.preference.req.engine", EMFCompareRCPPlugin.getDefault().getEMFComparePreferences(), tabComposite, this.reqEngineData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.req.engine", interactiveContent);
    }

    private void createEquiEngineTab(TabFolder tabFolder) {
        IItemRegistry equiEngineDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.equivalenceEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.equiEngineIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(equiEngineDescriptorRegistry, "org.eclipse.emf.compare.preference.equi.engine", EMFCompareRCPPlugin.getDefault().getEMFComparePreferences(), tabComposite, this.equiEngineData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.equi.engine", interactiveContent);
    }

    private void createDiffEngineTab(TabFolder tabFolder) {
        IItemRegistry diffEngineDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry();
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.differenceEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.diffEngineIntro.text"));
        InteractiveUIContent interactiveContent = this.createEngineUIBuilder(diffEngineDescriptorRegistry, "org.eclipse.emf.compare.preference.diff.engine", EMFCompareRCPPlugin.getDefault().getEMFComparePreferences(), tabComposite, this.diffEngineData);
        this.interactiveUis.put("org.eclipse.emf.compare.preference.diff.engine", interactiveContent);
    }

    private void createMatchEngineTab(TabFolder tabFolder) {
        IItemRegistry matchEngineFactoryDescriptorRegistry = EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry();
        IItemDescriptor defaultMatchEngineDescriptor = matchEngineFactoryDescriptorRegistry.getItemDescriptor(DefaultRCPMatchEngineFactory.class.getCanonicalName());
        Composite tabComposite = this.createTabSkeleton(tabFolder, EMFCompareRCPUIMessages.getString("EnginesPreferencePage.matchEngine.tab.label"), EMFCompareRCPUIMessages.getString("EnginesPreferencePage.matchEngineIntro.text"));
        Map<String, IConfigurationUIFactory> configuratorUIRegistry = EMFCompareRCPUIPlugin.getDefault().getMatchEngineConfiguratorRegistry();
        String matchEnginePreferenceKey = "org.eclipse.emf.compare.preference.match.engine";
        Set activeItems = ItemUtil.getActiveItems((IItemRegistry)matchEngineFactoryDescriptorRegistry, (String)matchEnginePreferenceKey);
        InteractiveUIContent.InteractiveUIBuilder builder = new InteractiveUIContent.InteractiveUIBuilder(tabComposite, matchEngineFactoryDescriptorRegistry);
        builder.setConfiguratorUIRegistry(configuratorUIRegistry).setDefaultCheck(activeItems).setConfigurationNodeKey("org.eclipse.emf.compare.preference.match.engine").setDefaultSelection(defaultMatchEngineDescriptor).setHoldingData(this.matchEnginesData);
        this.interactiveUis.put(matchEnginePreferenceKey, builder.build());
    }

    private Composite createTabSkeleton(TabFolder tabFolder, String tabLabel, String introText) {
        TabItem tbtmMain = new TabItem(tabFolder, 0);
        tbtmMain.setText(tabLabel);
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tbtmMain.setControl((Control)tabComposite);
        tabComposite.setLayout((Layout)new GridLayout(1, true));
        GridData layoutData = new GridData(4, 4, false, false, 1, 1);
        tabComposite.setLayoutData((Object)layoutData);
        Label introductionText = new Label(tabComposite, 64);
        introductionText.setText(introText);
        return tabComposite;
    }

    public boolean performOk() {
        this.setEnginesPreferences();
        this.storeConfigurations();
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder traceMessage = new StringBuilder("Engines preference serialization:\n");
            String prefDelimiter = " :\n";
            String new_line = "\n";
            traceMessage.append("org.eclipse.emf.compare.preference.diff.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.diff.engine")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.equi.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.equi.engine")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.req.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.req.engine")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.conflict.detector").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.conflict.detector")).append(new_line);
            traceMessage.append("org.eclipse.emf.compare.preference.match.engine").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.match.engine")).append(new_line);
            EMFCompareRCPPlugin.getDefault().log(1, traceMessage.toString());
        }
        return super.performOk();
    }

    private void setEnginesPreferences() {
        this.setEnginePreferences("org.eclipse.emf.compare.preference.diff.engine", this.diffEngineData.getData(), Collections.singleton(EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry().getHighestRankingDescriptor()));
        this.setEnginePreferences("org.eclipse.emf.compare.preference.equi.engine", this.equiEngineData.getData(), Collections.singleton(EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry().getHighestRankingDescriptor()));
        this.setEnginePreferences("org.eclipse.emf.compare.preference.req.engine", this.reqEngineData.getData(), Collections.singleton(EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry().getHighestRankingDescriptor()));
        this.setEnginePreferences("org.eclipse.emf.compare.preference.conflict.detector", this.conflictsDetectorData.getData(), Collections.singleton(EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry().getHighestRankingDescriptor()));
        HashSet matchEngineRegsitry = Sets.newHashSet((Iterable)EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry().getItemDescriptors());
        Sets.SetView matchingEngineToDisable = Sets.difference((Set)matchEngineRegsitry, this.matchEnginesData.getData());
        this.setEnginePreferences("org.eclipse.emf.compare.preference.match.engine", (Set)matchingEngineToDisable, Collections.emptyList());
    }

    private void storeConfigurations() {
        for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
            for (Map.Entry<String, AbstractConfigurationUI> configuratorEntry : interactiveContentEntry.getValue().getConfigurators().entrySet()) {
                AbstractConfigurationUI configurator = configuratorEntry.getValue();
                configurator.storeConfiguration();
            }
        }
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder traceMessage = new StringBuilder("Configuration serialization:\n");
            String prefDelimiter = " :\n";
            String new_line = "\n";
            String node_Label = "Node ";
            String double_dot_label = " : ";
            String empty_label = "EMPTY";
            for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
                String itemTypeId = interactiveContentEntry.getKey();
                for (Map.Entry<String, AbstractConfigurationUI> configuratorEntry : interactiveContentEntry.getValue().getConfigurators().entrySet()) {
                    String itemToConfigureId = configuratorEntry.getKey();
                    Preferences storeNode = ItemUtil.getConfigurationPreferenceNode((String)itemTypeId, (String)itemToConfigureId);
                    traceMessage.append(node_Label).append(storeNode.absolutePath()).append(prefDelimiter);
                    try {
                        String[] stringArray = storeNode.keys();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String propertyKey = stringArray[n2];
                            traceMessage.append(propertyKey).append(double_dot_label).append(storeNode.get(propertyKey, empty_label)).append(new_line);
                            ++n2;
                        }
                    }
                    catch (BackingStoreException e) {
                        e.printStackTrace();
                        traceMessage.append("Error in tracing ").append(storeNode.absolutePath());
                    }
                }
            }
            EMFCompareRCPPlugin.getDefault().log(1, traceMessage.toString());
        }
    }

    protected void performDefaults() {
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.diff.engine", this.diffEngineData);
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.req.engine", this.reqEngineData);
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.equi.engine", this.equiEngineData);
        this.resetDefaultPreferencesToHighestRank(EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry(), "org.eclipse.emf.compare.preference.conflict.detector", this.conflictsDetectorData);
        this.resetDefaultPreferencesToAll(EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryDescriptorRegistry(), "org.eclipse.emf.compare.preference.match.engine", this.matchEnginesData);
        this.resetConfigurations();
        super.performDefaults();
    }

    private void resetConfigurations() {
        for (Map.Entry<String, InteractiveUIContent> interactiveContentEntry : this.interactiveUis.entrySet()) {
            for (AbstractConfigurationUI configurator : interactiveContentEntry.getValue().getConfigurators().values()) {
                configurator.resetDefault();
            }
        }
    }

    private <T> void resetDefaultPreferencesToHighestRank(IItemRegistry<T> registry, String preferenceKey, DataHolder<T> dataObject) {
        InteractiveUIContent interactiveContent = this.interactiveUis.get(preferenceKey);
        if (interactiveContent != null) {
            IItemDescriptor defaultEngine = registry.getHighestRankingDescriptor();
            interactiveContent.select(defaultEngine);
            interactiveContent.checkElement(defaultEngine);
            dataObject.setData(Collections.singleton(defaultEngine));
        }
    }

    private <T> void resetDefaultPreferencesToAll(IItemRegistry<T> registry, String preferenceKey, DataHolder<T> dataObject) {
        InteractiveUIContent interactiveContent = this.interactiveUis.get(preferenceKey);
        if (interactiveContent != null) {
            IItemDescriptor defaultEngine = registry.getHighestRankingDescriptor();
            interactiveContent.select(defaultEngine);
            List itemDescriptors = registry.getItemDescriptors();
            interactiveContent.checkElements(itemDescriptors.toArray(new IItemDescriptor[itemDescriptors.size()]));
            dataObject.setData(Sets.newHashSet((Iterable)itemDescriptors));
        }
    }

    private <T> void setEnginePreferences(String preferenceKey, Set<IItemDescriptor<T>> currentSelectedEngine, Collection<IItemDescriptor<T>> defaultConf) {
        if (currentSelectedEngine != null && !currentSelectedEngine.contains(defaultConf)) {
            StringBuilder descriptorsKey = new StringBuilder();
            Iterator<IItemDescriptor<T>> iterator = currentSelectedEngine.iterator();
            while (iterator.hasNext()) {
                IItemDescriptor<T> iItemDescriptor = iterator.next();
                descriptorsKey.append(iItemDescriptor.getID());
                if (!iterator.hasNext()) continue;
                descriptorsKey.append(";");
            }
            this.getPreferenceStore().setValue(preferenceKey, descriptorsKey.toString());
        } else {
            this.getPreferenceStore().setToDefault(preferenceKey);
        }
    }
}

