/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ReferenceChangeItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemFontProvider;

public class ReferenceChangeItemProviderSpec
extends ReferenceChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static final int ELIDE_LENGTH = 50;
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public ReferenceChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    static String changeText(Diff diff, EStructuralFeature feature) {
        EObject otherSide;
        EObject sourceSide;
        DifferenceSource source = diff.getSource();
        Match matchOfInterrest = diff.getMatch();
        if (source == DifferenceSource.LEFT) {
            sourceSide = matchOfInterrest.getLeft();
            otherSide = matchOfInterrest.getRight();
        } else {
            sourceSide = matchOfInterrest.getRight();
            otherSide = matchOfInterrest.getLeft();
        }
        String changeText = ReferenceChangeItemProviderSpec.changeText(feature, sourceSide, otherSide);
        return changeText;
    }

    private static String changeText(EStructuralFeature eStructuralFeature, EObject sourceSide, EObject otherSide) {
        Object otherValue;
        Object leftValue;
        String changeText = sourceSide != null ? ((leftValue = ReferenceUtil.safeEGet((EObject)sourceSide, (EStructuralFeature)eStructuralFeature)) == null || ReferenceChangeItemProviderSpec.isStringAndNullOrEmpty(leftValue) ? EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.unset") : (otherSide != null ? ((otherValue = ReferenceUtil.safeEGet((EObject)otherSide, (EStructuralFeature)eStructuralFeature)) == null || ReferenceChangeItemProviderSpec.isStringAndNullOrEmpty(otherValue) ? EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.set") : EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.changed")) : EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.set"))) : EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.unset");
        return changeText;
    }

    private static boolean isStringAndNullOrEmpty(Object s) {
        if (s instanceof String) {
            return com.google.common.base.Strings.isNullOrEmpty((String)((String)s));
        }
        return false;
    }

    protected String getReferenceText(ReferenceChange refChange) {
        return refChange.getReference().getName();
    }

    protected String getValueText(ReferenceChange refChange) {
        EObject refChangeValue = refChange.getValue();
        String value = this.itemDelegator.getText((Object)refChangeValue);
        value = com.google.common.base.Strings.isNullOrEmpty((String)value) ? (refChangeValue.eIsProxy() ? "proxy : " + ((InternalEObject)refChangeValue).eProxyURI().toString() : "<null>") : Strings.elide(value, 50, "...");
        return value;
    }

    public Object getImage(Object object) {
        ReferenceChange refChange = (ReferenceChange)object;
        Object refChangeValueImage = this.itemDelegator.getImage((Object)refChange.getValue());
        Object diffImage = this.overlayProvider.getComposedImage((Diff)refChange, refChangeValueImage);
        Object ret = this.overlayImage(object, diffImage);
        return ret;
    }

    public Object getForeground(Object object) {
        ReferenceChange referenceChange = (ReferenceChange)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        EObject refChangeValue;
        ReferenceChange refChange = (ReferenceChange)object;
        String valueText = this.getValueText(refChange);
        String referenceText = this.getReferenceText(refChange);
        ComposedStyledString ret = new ComposedStyledString();
        if (refChange.getReference().isContainment()) {
            EObject value = refChange.getValue();
            Match match = refChange.getMatch().getComparison().getMatch(value);
            if (match != null) {
                Iterable subDifferences = match.getAllDifferences();
                if (refChange.getState() != DifferenceState.UNRESOLVED && Iterables.any((Iterable)subDifferences, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}))) {
                    ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
                }
            }
        }
        if ((refChangeValue = refChange.getValue()).eIsProxy()) {
            IStyledString.Style italic = IStyledString.Style.builder().setFont(IItemFontProvider.ITALIC_FONT).build();
            ret.append(valueText, italic);
        } else {
            ret.append(valueText);
        }
        ret.append(" [" + referenceText, IStyledString.Style.DECORATIONS_STYLER);
        switch (refChange.getKind()) {
            case ADD: {
                ret.append(String.valueOf(' ') + EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.decoration.add"), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(String.valueOf(' ') + EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.decoration.delete"), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(String.valueOf(' ') + ReferenceChangeItemProviderSpec.changeText((Diff)refChange, (EStructuralFeature)refChange.getReference()), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(String.valueOf(' ') + EMFCompareEditMessages.getString("ReferenceChangeItemProviderSpec.decoration.move"), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + refChange.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    public String getDescription(Object object) {
        ReferenceChange refChange = (ReferenceChange)object;
        String valueText = this.getValueText(refChange);
        String referenceText = this.getReferenceText(refChange);
        String remotely = "";
        if (refChange.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String ret = "";
        switch (refChange.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + " has been " + remotely + "added to " + referenceText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "deleted from " + referenceText;
                break;
            }
            case CHANGE: {
                String changeText = ReferenceChangeItemProviderSpec.changeText((Diff)refChange, (EStructuralFeature)refChange.getReference());
                ret = String.valueOf(referenceText) + " " + valueText + " has been " + remotely + changeText;
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "moved in " + referenceText;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + refChange.getKind());
            }
        }
        return ret;
    }
}

