/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAllNonConflictingAction
extends MergeAction {
    private Comparison comparison;

    public MergeAllNonConflictingAction(ICompareEditingDomain editingDomain, Comparison comparison, IMerger.Registry mergerRegistry, MergeMode mode, boolean isLeftEditable, boolean isRightEditable) {
        super(editingDomain, mergerRegistry, mode, isLeftEditable, isRightEditable, null);
        this.comparison = comparison;
    }

    @Override
    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.all.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_right.gif"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.all.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_left.gif"));
                break;
            }
            case ACCEPT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.all.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept_all_changes.gif"));
                break;
            }
            case REJECT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.all.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject_all_changes.gif"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
        this.clearCache();
        this.setEnabled(comparison != null);
    }

    @Override
    protected List<Diff> getDifferencesToMerge() {
        Iterable differences = Iterables.filter((Iterable)this.comparison.getDifferences(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.WITHOUT_CONFLICT, (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
        return Lists.newArrayList((Iterable)differences);
    }

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        return true;
    }
}

