/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverDescriptor;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelResolverRegistry {
    private final Map<String, ModelResolverDescriptor> registeredDescriptors = new LinkedHashMap<String, ModelResolverDescriptor>();
    private ThreadedModelResolver defaultResolver;

    public List<ModelResolverDescriptor> getRegisteredDescriptors() {
        return new ArrayList<ModelResolverDescriptor>(this.registeredDescriptors.values());
    }

    public IModelResolver getBestResolverFor(IStorage sourceStorage) {
        if (!this.isEnabled()) {
            return this.defaultResolver;
        }
        ModelResolverDescriptor resolver = null;
        for (ModelResolverDescriptor candidate : this.registeredDescriptors.values()) {
            if (resolver != null && resolver.getRanking() >= candidate.getRanking() || !candidate.getModelResolver().canResolve(sourceStorage)) continue;
            resolver = candidate;
        }
        if (resolver != null) {
            return resolver.getModelResolver();
        }
        return this.defaultResolver;
    }

    public boolean isEnabled() {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        return !store.getBoolean("org.eclipse.emf.compare.ide.ui.preference.disableResolving");
    }

    void addResolver(String key, ModelResolverDescriptor descriptor) {
        if (ThreadedModelResolver.class.getName().equals(key)) {
            this.defaultResolver = (ThreadedModelResolver)descriptor.getModelResolver();
        }
        this.registeredDescriptors.put(key, descriptor);
    }

    ModelResolverDescriptor removeResolver(String key) {
        ModelResolverDescriptor descriptor = this.registeredDescriptors.remove(key);
        if (descriptor != null) {
            descriptor.dispose();
        }
        return descriptor;
    }

    public void clear() {
        Iterator<ModelResolverDescriptor> descriptors = this.registeredDescriptors.values().iterator();
        while (descriptors.hasNext()) {
            descriptors.next().dispose();
            descriptors.remove();
        }
    }
}

