/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.provider.custom;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.provider.ExtendedAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.provider.custom.UMLDiffCustomItemProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.NamedElement;

public class StereotypeAttributeChangeCustomItemProvider
extends UMLDiffCustomItemProvider {
    private final ExtendedAdapterFactoryItemDelegator itemDelegator = new ExtendedAdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public StereotypeAttributeChangeCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        String action;
        UMLDiff umlDiff = (UMLDiff)object;
        EObject discriminant = umlDiff.getDiscriminant();
        ComposedStyledString stereotypeText = new ComposedStyledString();
        if (discriminant instanceof NamedElement) {
            stereotypeText.append("Stereotype Property " + ((NamedElement)discriminant).getName() + ' ');
        } else if (discriminant instanceof EAttribute) {
            stereotypeText.append("Stereotype Property " + ((EAttribute)discriminant).getName() + ' ');
        } else {
            stereotypeText.append("Stereotype Property ");
        }
        switch (umlDiff.getKind()) {
            case ADD: {
                action = "add";
                break;
            }
            case DELETE: {
                action = "remove";
                break;
            }
            case CHANGE: {
                action = "changed";
                break;
            }
            case MOVE: {
                action = "moved";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        return stereotypeText.append(" [stereotype attribute " + action + "]", IStyledString.Style.DECORATIONS_STYLER);
    }
}

