/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.spec.EObjectUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.ResourceAttachmentChangeMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeViewerItem
extends AdapterImpl
implements IMergeViewerItem {
    private final Object fLeft;
    private final Object fRight;
    private final Object fAncestor;
    private final Diff fDiff;
    private final Comparison fComparison;
    private final IMergeViewer.MergeViewerSide fSide;
    private final AdapterFactory fAdapterFactory;

    public MergeViewerItem(Comparison comparison, Diff diff, Object left, Object right, Object ancestor, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        this.fLeft = left;
        this.fRight = right;
        this.fAncestor = ancestor;
        this.fDiff = diff;
        this.fSide = side;
        this.fAdapterFactory = adapterFactory;
        this.fComparison = comparison;
    }

    public MergeViewerItem(Comparison comparison, Diff diff, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        this(comparison, diff, match.getLeft(), match.getRight(), match.getOrigin(), side, adapterFactory);
    }

    @Override
    public final Diff getDiff() {
        return this.fDiff;
    }

    @Override
    public final Object getAncestor() {
        return this.fAncestor;
    }

    @Override
    public final Object getLeft() {
        return this.fLeft;
    }

    @Override
    public final Object getRight() {
        return this.fRight;
    }

    @Override
    public final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    @Override
    public final Object getSideValue(IMergeViewer.MergeViewerSide side) {
        switch (side) {
            case LEFT: {
                return this.fLeft;
            }
            case RIGHT: {
                return this.fRight;
            }
            case ANCESTOR: {
                return this.fAncestor;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IMergeViewerItem.Container getParent() {
        IMergeViewerItem.Container ret = null;
        if (this.getDiff() instanceof ResourceAttachmentChange) {
            ret = this.createBasicContainer((ResourceAttachmentChange)this.getDiff());
        } else {
            Object parent;
            Object sideValue = this.getBestSideValue();
            ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.fAdapterFactory.adapt(sideValue, ITreeItemContentProvider.class);
            Object object = parent = treeItemContentProvider != null ? treeItemContentProvider.getParent(sideValue) : null;
            if (parent instanceof EObject) {
                ret = this.createBasicContainer((EObject)parent);
            }
        }
        return ret;
    }

    public IMergeViewerItem cloneAsOpposite() {
        return new MergeViewerItem(this.getComparison(), this.getDiff(), this.getLeft(), this.getRight(), this.getAncestor(), this.getSide(), this.getAdapterFactory());
    }

    protected final Object getBestSideValue() {
        Object sideValue;
        if (this.fSide != IMergeViewer.MergeViewerSide.ANCESTOR) {
            sideValue = this.getSideValue(this.fSide);
            if (sideValue == null && (sideValue = this.getSideValue(this.fSide.opposite())) == null) {
                sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.ANCESTOR);
            }
        } else {
            sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.ANCESTOR);
            if (sideValue == null && (sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.LEFT)) == null) {
                sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.RIGHT);
            }
        }
        return sideValue;
    }

    @Override
    public boolean isInsertionPoint() {
        return this.getSideValue(this.getSide()) == null && this.getDiff() != null;
    }

    public String toString() {
        String className = this.getClass().getName();
        int start = className.lastIndexOf(46);
        return Objects.toStringHelper((String)className.substring(start + 1)).add("ancestor", (Object)EObjectUtil.getLabel((EObject)((EObject)this.getAncestor()))).add("left", (Object)EObjectUtil.getLabel((EObject)((EObject)this.getLeft()))).add("right", (Object)EObjectUtil.getLabel((EObject)((EObject)this.getRight()))).add("side", (Object)this.getSide()).add("diff", (Object)this.getDiff()).toString();
    }

    protected final Comparison getComparison() {
        return this.fComparison;
    }

    protected final AdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    protected final IMergeViewerItem.Container createBasicContainer(EObject eObject) {
        IMergeViewerItem.Container ret = null;
        Match parentMatch = this.fComparison.getMatch(eObject);
        if (parentMatch == null) {
            return null;
        }
        EObject expectedValue = MergeViewerUtil.getEObject(parentMatch, this.fSide);
        if (expectedValue != null) {
            Iterable<? extends Diff> diffs = this.getDiffsWithValue(expectedValue, parentMatch);
            Diff diff = (Diff)Iterables.getFirst(diffs, null);
            ret = new Container(this.fComparison, diff, parentMatch, this.fSide, this.fAdapterFactory);
        } else {
            expectedValue = MergeViewerUtil.getEObject(parentMatch, this.fSide.opposite());
            Iterable<Object> diffs = Lists.newArrayList();
            if (expectedValue != null) {
                diffs = this.getDiffsWithValue(expectedValue, parentMatch);
            }
            if (Iterables.isEmpty((Iterable)diffs) && (expectedValue = MergeViewerUtil.getEObject(parentMatch, IMergeViewer.MergeViewerSide.ANCESTOR)) != null) {
                diffs = this.getDiffsWithValue(expectedValue, parentMatch);
            }
            if (!Iterables.isEmpty((Iterable)diffs)) {
                Diff diff = (Diff)diffs.iterator().next();
                ret = diff instanceof ResourceAttachmentChange ? new Container(this.fComparison, diff, parentMatch, this.fSide, this.fAdapterFactory) : this.createInsertionPoint(diff, this.fSide, this.fAdapterFactory);
            }
        }
        return ret;
    }

    private Iterable<? extends Diff> getDiffsWithValue(EObject expectedValue, Match parentMatch) {
        Iterable diffs = Iterables.filter((Iterable)this.fComparison.getDifferences(expectedValue), (Predicate)EMFComparePredicates.containmentReferenceChange());
        if (Iterables.size((Iterable)diffs) > 1) {
            throw new IllegalStateException("Should not have more than one ReferenceChange on each Match");
        }
        Diff referenceChange = (Diff)Iterables.getFirst((Iterable)diffs, null);
        if (referenceChange == null) {
            diffs = Iterables.filter((Iterable)parentMatch.getDifferences(), (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class));
        }
        return diffs;
    }

    protected final IMergeViewerItem.Container createBasicContainer(ResourceAttachmentChange diff) {
        Comparison comparison = this.getComparison();
        Resource left = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, (Diff)diff);
        Resource right = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, (Diff)diff);
        Resource ancestor = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)diff);
        ResourceAttachmentChangeMergeViewerItem ret = new ResourceAttachmentChangeMergeViewerItem(comparison, null, left, right, ancestor, this.getSide(), this.getAdapterFactory());
        return ret;
    }

    protected final List<IMergeViewerItem> createInsertionPoints(Comparison comparison, EStructuralFeature eStructuralFeature, List<? extends IMergeViewerItem> values, List<? extends Diff> differences) {
        ArrayList ret = Lists.newArrayList(values);
        List sideContent = ReferenceUtil.getAsList((EObject)((EObject)this.getSideValue(this.getSide())), (EStructuralFeature)eStructuralFeature);
        List oppositeContent = ReferenceUtil.getAsList((EObject)((EObject)this.getSideValue(this.getSide().opposite())), (EStructuralFeature)eStructuralFeature);
        for (Diff diff : Lists.reverse(differences)) {
            boolean b6;
            EObject value = (EObject)MergeViewerUtil.getDiffValue(diff);
            Match match = this.getComparison().getMatch(value);
            DifferenceSource source = diff.getSource();
            DifferenceKind kind = diff.getKind();
            DifferenceState state = diff.getState();
            boolean b1 = source == DifferenceSource.LEFT && kind == DifferenceKind.DELETE && this.getSide() == IMergeViewer.MergeViewerSide.LEFT && DifferenceState.MERGED != state;
            boolean b2 = source == DifferenceSource.LEFT && kind == DifferenceKind.ADD && this.getSide() == IMergeViewer.MergeViewerSide.RIGHT && DifferenceState.MERGED != state;
            boolean b3 = source == DifferenceSource.RIGHT && kind == DifferenceKind.ADD && this.getSide() == IMergeViewer.MergeViewerSide.LEFT && DifferenceState.MERGED != state;
            boolean b4 = source == DifferenceSource.RIGHT && kind == DifferenceKind.DELETE && this.getSide() == IMergeViewer.MergeViewerSide.RIGHT && DifferenceState.MERGED != state;
            boolean b5 = (match == null || match.getLeft() == null && match.getRight() == null) && DifferenceState.MERGED == state;
            boolean bl = b6 = diff.getConflict() == null || diff.getConflict().getKind() != ConflictKind.PSEUDO || kind == DifferenceKind.DELETE;
            if (!b1 && !b2 && !b3 && !b4 && !b5 || !b6) continue;
            if (match == null && DifferenceState.MERGED == state) {
                EObject bestSideValue = (EObject)this.getBestSideValue();
                match = this.getComparison().getMatch(bestSideValue);
                match = this.getMatchWithNullValues(match);
            }
            if (match == null) continue;
            Container insertionPoint = new Container(this.getComparison(), diff, match.getLeft(), match.getRight(), match.getOrigin(), this.getSide(), this.getAdapterFactory());
            int insertionIndex = match.getLeft() == null && match.getRight() == null && diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.PSEUDO ? ReferenceUtil.getAsList((EObject)((EObject)this.getSideValue(IMergeViewer.MergeViewerSide.ANCESTOR)), (EStructuralFeature)eStructuralFeature).indexOf(value) : Math.min(DiffUtil.findInsertionIndex((Comparison)comparison, (List)oppositeContent, (List)sideContent, (Object)value), ret.size());
            int realIndex = 0;
            int index = 0;
            while (index < insertionIndex && realIndex < ret.size()) {
                if (!((IMergeViewerItem)ret.get(realIndex)).isInsertionPoint()) {
                    ++index;
                }
                ++realIndex;
            }
            ret.add(realIndex, insertionPoint);
        }
        return ret;
    }

    private Match getMatchWithNullValues(Match match) {
        for (Match subMatch : match.getSubmatches()) {
            if (subMatch.getLeft() != null || subMatch.getRight() != null) continue;
            return subMatch;
        }
        return null;
    }

    private IMergeViewerItem.Container createInsertionPoint(Diff diff, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        Object left = MergeViewerUtil.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.LEFT);
        Object right = MergeViewerUtil.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.RIGHT);
        Container insertionPoint = null;
        if (left != null || right != null) {
            boolean rightEmptyBox;
            boolean leftEmptyBox = side == IMergeViewer.MergeViewerSide.LEFT && (left == null || !MergeViewerUtil.getValues(diff, side).contains(left));
            boolean bl = rightEmptyBox = side == IMergeViewer.MergeViewerSide.RIGHT && (right == null || !MergeViewerUtil.getValues(diff, side).contains(right));
            if (leftEmptyBox || rightEmptyBox) {
                Object ancestor = MergeViewerUtil.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.ANCESTOR);
                insertionPoint = new Container(this.getComparison(), diff, left, right, ancestor, side, adapterFactory);
            }
        }
        return insertionPoint;
    }

    protected final List<IMergeViewerItem> createMergeViewerItemFrom(Collection<?> values) {
        ArrayList ret = Lists.newArrayListWithCapacity((int)values.size());
        for (Object value : values) {
            IMergeViewerItem valueToAdd = this.createMergeViewerItemFrom((EObject)value);
            if (valueToAdd == null) continue;
            ret.add(valueToAdd);
        }
        return ret;
    }

    protected IMergeViewerItem createMergeViewerItemFrom(EObject eObject) {
        Match match = this.getComparison().getMatch(eObject);
        ReferenceChange referenceChange = (ReferenceChange)Iterables.getFirst((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(eObject), (Predicate)EMFComparePredicates.containmentReferenceChange()), null);
        if (match != null) {
            return new Container(this.getComparison(), (Diff)referenceChange, match, this.getSide(), this.getAdapterFactory());
        }
        switch (this.getSide()) {
            case LEFT: {
                return new Container(this.getComparison(), (Diff)referenceChange, eObject, null, null, this.getSide(), this.getAdapterFactory());
            }
            case RIGHT: {
                return new Container(this.getComparison(), (Diff)referenceChange, null, eObject, null, this.getSide(), this.getAdapterFactory());
            }
            case ANCESTOR: {
                return new Container(this.getComparison(), (Diff)referenceChange, null, null, eObject, this.getSide(), this.getAdapterFactory());
            }
        }
        throw new IllegalStateException();
    }

    protected List<? extends Diff> filteredDiffs(List<? extends Diff> unfilteredDiffs, Predicate<? super EObject> predicate, IDifferenceGroupProvider group) {
        if (predicate != null) {
            ArrayList filteredDiffs = Lists.newArrayList(unfilteredDiffs);
            for (Diff diff : unfilteredDiffs) {
                if (MergeViewerUtil.isVisibleInMergeViewer(diff, group, predicate)) continue;
                filteredDiffs.remove(diff);
            }
            return filteredDiffs;
        }
        return unfilteredDiffs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Container
    extends MergeViewerItem
    implements IMergeViewerItem.Container {
        private static final IMergeViewerItem[] NO_ITEMS_ARR = new IMergeViewerItem[0];

        public Container(Comparison comparison, Diff diff, Object left, Object right, Object ancestor, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
            super(comparison, diff, left, right, ancestor, side, adapterFactory);
        }

        public Container(Comparison comparison, Diff diff, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
            super(comparison, diff, match, side, adapterFactory);
        }

        public static IMergeViewerItem[] getNoItemsArr() {
            return NO_ITEMS_ARR;
        }

        @Override
        public IMergeViewerItem.Container getParent() {
            IMergeViewerItem.Container ret = null;
            if (this.getDiff() instanceof ResourceAttachmentChange) {
                ret = this.createBasicContainer((ResourceAttachmentChange)this.getDiff());
            } else {
                Object parent;
                Object sideValue = this.getBestSideValue();
                ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.getAdapterFactory().adapt(sideValue, ITreeItemContentProvider.class);
                Object object = parent = treeItemContentProvider != null ? treeItemContentProvider.getParent(sideValue) : null;
                if (parent instanceof EObject) {
                    ret = this.createBasicContainer((EObject)parent);
                }
            }
            return ret;
        }

        @Override
        public boolean hasChildren(IDifferenceGroupProvider group, Predicate<? super EObject> predicate) {
            return this.getChildren(group, predicate).length > 0;
        }

        @Override
        public IMergeViewerItem.Container cloneAsOpposite() {
            return new Container(this.getComparison(), this.getDiff(), this.getLeft(), this.getRight(), this.getAncestor(), this.getSide(), this.getAdapterFactory());
        }

        @Override
        public IMergeViewerItem[] getChildren(IDifferenceGroupProvider group, Predicate<? super EObject> predicate) {
            Object sideValue = this.getSideValue(this.getSide());
            EObject bestSideValue = (EObject)this.getBestSideValue();
            Collection<EReference> childrenFeatures = this.getChildrenFeatures(bestSideValue);
            Match match = this.getComparison().getMatch(bestSideValue);
            ImmutableList differences = match != null ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)match.getDifferences(), (Predicate)EMFComparePredicates.containmentReferenceChange())) : ImmutableList.of();
            ArrayList ret = Lists.newArrayList();
            for (EStructuralFeature eStructuralFeature : childrenFeatures) {
                List featureContent = ReferenceUtil.getAsList((EObject)((EObject)sideValue), (EStructuralFeature)eStructuralFeature);
                List<IMergeViewerItem> mergeViewerItem = this.createMergeViewerItemFrom(featureContent);
                if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
                    ImmutableList differencesOnFeature = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.onFeature((String)eStructuralFeature.getName())));
                    ret.addAll(this.createInsertionPoints(this.getComparison(), eStructuralFeature, mergeViewerItem, this.filteredDiffs((List<? extends Diff>)differencesOnFeature, predicate, group)));
                    continue;
                }
                ret.addAll(mergeViewerItem);
            }
            return ret.toArray(NO_ITEMS_ARR);
        }

        protected Collection<EReference> getChildrenFeatures(Object object) {
            Collection<Object> ret = Lists.newArrayList();
            Collection<? extends EStructuralFeature> childrenFeaturesFromItemProviderAdapter = this.getChildrenFeaturesFromItemProviderAdapter(object);
            if (childrenFeaturesFromItemProviderAdapter == null) {
                ret = this.getChildrenFeaturesFromEClass(object);
            } else {
                Iterables.addAll((Collection)ret, (Iterable)Iterables.filter(childrenFeaturesFromItemProviderAdapter, EReference.class));
            }
            return ret;
        }

        protected Collection<EReference> getChildrenFeaturesFromEClass(Object object) {
            ImmutableSet.Builder features = ImmutableSet.builder();
            if (object instanceof EObject) {
                for (EReference feature : ((EObject)object).eClass().getEAllContainments()) {
                    features.add((Object)feature);
                }
            }
            return features.build();
        }

        protected Collection<? extends EStructuralFeature> getChildrenFeaturesFromItemProviderAdapter(Object object) {
            Collection ret = null;
            Object treeItemContentProvider = this.getAdapterFactory().adapt(object, ITreeItemContentProvider.class);
            if (treeItemContentProvider instanceof ItemProviderAdapter) {
                ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)treeItemContentProvider;
                try {
                    Method method = itemProviderAdapter.getClass().getMethod("getChildrenFeatures", Object.class);
                    method.setAccessible(true);
                    ret = (Collection)method.invoke((Object)itemProviderAdapter, object);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            return ret;
        }
    }
}

