/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDifferenceGroupImpl
extends AdapterImpl
implements IDifferenceGroup {
    protected final Predicate<? super Diff> filter;
    protected final String name;
    protected final Image image;
    protected final Comparison comparison;
    protected List<TreeNode> children;
    private final IDifferenceGroupExtender.Registry registry = EMFCompareRCPUIPlugin.getDefault().getDifferenceGroupExtenderRegistry();
    protected static final Function<EObject, Iterator<EObject>> E_ALL_CONTENTS = new Function<EObject, Iterator<EObject>>(){

        public Iterator<EObject> apply(EObject eObject) {
            return eObject.eAllContents();
        }
    };

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter) {
        this(comparison, filter, "Group", EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"));
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name) {
        this(comparison, filter, name, EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"));
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, Image image) {
        this.comparison = comparison;
        this.filter = filter;
        this.name = name;
        this.image = image;
    }

    public boolean isAdapterForType(Object type) {
        return type == IDifferenceGroup.class;
    }

    @Override
    public Comparison getComparison() {
        return this.comparison;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStyledString.IComposedStyledString getStyledName() {
        ComposedStyledString ret = new ComposedStyledString();
        Iterator eAllContents = Iterators.concat((Iterator)Iterators.transform(this.getGroupTree().iterator(), E_ALL_CONTENTS));
        Iterator eAllData = Iterators.transform((Iterator)eAllContents, (Function)TREE_NODE_DATA);
        boolean unresolvedDiffs = Iterators.any((Iterator)Iterators.filter((Iterator)eAllData, Diff.class), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        if (unresolvedDiffs) {
            ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
        }
        ret.append(this.getName());
        return ret;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public List<? extends TreeNode> getGroupTree() {
        if (this.children == null) {
            TreeNode buildSubTree;
            this.children = Lists.newArrayList();
            for (Match match : this.comparison.getMatches()) {
                buildSubTree = this.buildSubTree((Match)null, match);
                if (buildSubTree == null) continue;
                this.children.addAll((Collection<TreeNode>)buildSubTree);
            }
            for (MatchResource matchResource : this.comparison.getMatchedResources()) {
                buildSubTree = this.buildSubTree(matchResource);
                if (buildSubTree == null) continue;
                this.children.add(buildSubTree);
            }
        }
        return this.children;
    }

    protected TreeNode buildSubTree(MatchResource matchResource) {
        TreeNode treeNode = this.wrap((EObject)matchResource);
        for (Match match : this.comparison.getMatches()) {
            treeNode.getChildren().addAll(this.buildSubTree(matchResource, match));
        }
        return treeNode;
    }

    protected List<TreeNode> buildSubTree(MatchResource matchResource, Match match) {
        ArrayList ret = Lists.newArrayList();
        if (this.isRootOfResourceURI(match.getLeft(), matchResource.getLeftURI()) || this.isRootOfResourceURI(match.getRight(), matchResource.getRightURI()) || this.isRootOfResourceURI(match.getOrigin(), matchResource.getOriginURI())) {
            Collection resourceAttachmentChanges = Collections2.filter((Collection)match.getDifferences(), BasicDifferenceGroupImpl.resourceAttachmentChange());
            for (Diff diff : resourceAttachmentChanges) {
                ret.add(this.wrap((EObject)diff));
            }
        } else {
            for (Match subMatch : match.getSubmatches()) {
                ret.addAll(this.buildSubTree(matchResource, subMatch));
            }
        }
        return ret;
    }

    public List<TreeNode> buildSubTree(Match parentMatch, Match match) {
        Collection containmentChanges;
        ArrayList ret = Lists.newArrayList();
        boolean isContainment = false;
        if (parentMatch != null && !(containmentChanges = Collections2.filter((Collection)parentMatch.getDifferences(), this.containmentReferenceForMatch(match))).isEmpty()) {
            isContainment = true;
            for (Diff diff : containmentChanges) {
                ret.add(this.wrap((EObject)diff));
            }
        }
        if (ret.isEmpty() && !this.matchWithLeftAndRightInDifferentContainer(match)) {
            ret.add(this.wrap((EObject)match));
        }
        ArrayList toRemove = Lists.newArrayList();
        for (TreeNode treeNode : ret) {
            Object buildSubTree;
            boolean hasDiff = false;
            boolean hasNonEmptySubMatch = false;
            for (Diff diff : Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.and(this.filter, (Predicate)Predicates.not((Predicate)Predicates.or((Predicate)EMFComparePredicates.containmentReferenceChange(), BasicDifferenceGroupImpl.resourceAttachmentChange()))))) {
                hasDiff = true;
                buildSubTree = this.buildSubTree(diff);
                if (buildSubTree == null) continue;
                treeNode.getChildren().add(buildSubTree);
            }
            for (Match subMatch : match.getSubmatches()) {
                buildSubTree = this.buildSubTree(match, subMatch);
                if (buildSubTree.isEmpty()) continue;
                hasNonEmptySubMatch = true;
                treeNode.getChildren().addAll((Collection)buildSubTree);
            }
            for (Diff diff : Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.and(this.filter, (Predicate)EMFComparePredicates.containmentMoveReferenceChange()))) {
                if (this.containsChildrenWithDataEqualsToDiff(treeNode, diff) || (buildSubTree = this.buildSubTree(diff)) == null) continue;
                hasDiff = true;
                treeNode.getChildren().add(buildSubTree);
                List<TreeNode> matchSubTree = this.buildSubTree((Match)null, this.getComparison().getMatch(((ReferenceChange)diff).getValue()));
                for (TreeNode matchSubTreeNode : matchSubTree) {
                    buildSubTree.getChildren().addAll((Collection)matchSubTreeNode.getChildren());
                }
            }
            if (!(isContainment || hasDiff || hasNonEmptySubMatch || this.filter.equals((Object)Predicates.alwaysTrue()))) {
                toRemove.add(treeNode);
                continue;
            }
            for (IDifferenceGroupExtender ext : this.registry.getExtenders()) {
                if (!ext.handle(treeNode)) continue;
                ext.addChildren(treeNode);
            }
        }
        ret.removeAll(toRemove);
        return ret;
    }

    protected TreeNode buildSubTree(Diff diff) {
        TreeNode treeNode = this.wrap((EObject)diff);
        for (IDifferenceGroupExtender ext : this.registry.getExtenders()) {
            if (!ext.handle(treeNode)) continue;
            ext.addChildren(treeNode);
        }
        return treeNode;
    }

    protected boolean isRootOfResourceURI(EObject eObject, String uri) {
        return eObject != null && uri != null && eObject.eResource() != null && uri.equals(eObject.eResource().getURI().toString());
    }

    protected static Predicate<? super Diff> resourceAttachmentChange() {
        return Predicates.instanceOf(ResourceAttachmentChange.class);
    }

    public boolean matchWithLeftAndRightInDifferentContainer(Match match) {
        EObject left = match.getLeft();
        EObject right = match.getRight();
        if (left != null && right != null) {
            return this.getComparison().getMatch(left.eContainer()) != this.getComparison().getMatch(right.eContainer());
        }
        return false;
    }

    protected boolean containsChildrenWithDataEqualsToDiff(TreeNode treeNode, Diff diff) {
        for (TreeNode child : treeNode.getChildren()) {
            if (diff != child.getData()) continue;
            return true;
        }
        return false;
    }

    protected Predicate<Diff> containmentReferenceForMatch(Match subMatch) {
        return Predicates.and((Predicate[])new Predicate[]{this.filter, EMFComparePredicates.containmentReferenceChange(), Predicates.or((Predicate[])new Predicate[]{EMFComparePredicates.valueIs((Object)subMatch.getLeft()), EMFComparePredicates.valueIs((Object)subMatch.getRight()), EMFComparePredicates.valueIs((Object)subMatch.getOrigin())})});
    }

    protected TreeNode wrap(EObject data) {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData(data);
        treeNode.eAdapters().add((Object)this);
        return treeNode;
    }
}

