/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilterSelectionChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMergeViewerFilter
extends ViewerFilter {
    private final Set<Predicate<? super EObject>> predicates;
    private final List<TreeViewer> viewers;
    private final EventBus eventBus;

    public StructureMergeViewerFilter(EventBus eventBus) {
        this.eventBus = eventBus;
        this.predicates = Sets.newLinkedHashSet();
        this.viewers = Lists.newArrayList();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Notifier notifier;
        if (this.getPredicates().isEmpty()) {
            return true;
        }
        boolean result = true;
        Predicate predicate = Predicates.or(this.getPredicates());
        if (element instanceof GroupItemProviderAdapter) {
            result = ((GroupItemProviderAdapter)((Object)element)).hasChildren(element);
        } else if (element instanceof Adapter && (notifier = ((Adapter)element).getTarget()) instanceof EObject) {
            EObject eObject = (EObject)notifier;
            result = this.keepNode(eObject, (Predicate<? super EObject>)predicate);
        }
        return result;
    }

    private boolean keepNode(EObject eObject, Predicate<? super EObject> predicate) {
        EObject data;
        boolean result = !predicate.apply((Object)eObject);
        EList eContents = eObject.eContents();
        if (result && !eContents.isEmpty() && eObject instanceof TreeNode && ((data = ((TreeNode)eObject).getData()) instanceof Match || data instanceof Conflict || data instanceof MatchResource)) {
            result = false;
            for (EObject child : eContents) {
                if (!this.keepNode(child, predicate)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void addFilters(Collection<IDifferenceFilter> filters) {
        for (IDifferenceFilter filter : filters) {
            this.getPredicates().remove(filter.getPredicateWhenUnselected());
            this.getPredicates().add(filter.getPredicateWhenSelected());
        }
        this.refreshViewers();
        for (IDifferenceFilter filter : filters) {
            this.eventBus.post((Object)new IDifferenceFilterSelectionChangeEvent.DefaultFilterSelectionChangeEvent(filter, IDifferenceFilterSelectionChangeEvent.Action.ACTIVATE));
        }
    }

    public void addFilter(IDifferenceFilter filter) {
        this.getPredicates().remove(filter.getPredicateWhenUnselected());
        this.addPredicate(filter.getPredicateWhenSelected());
        this.eventBus.post((Object)new IDifferenceFilterSelectionChangeEvent.DefaultFilterSelectionChangeEvent(filter, IDifferenceFilterSelectionChangeEvent.Action.ACTIVATE));
    }

    public void removeFilter(IDifferenceFilter filter) {
        this.getPredicates().add(filter.getPredicateWhenUnselected());
        this.removePredicate(filter.getPredicateWhenSelected());
        this.eventBus.post((Object)new IDifferenceFilterSelectionChangeEvent.DefaultFilterSelectionChangeEvent(filter, IDifferenceFilterSelectionChangeEvent.Action.DEACTIVATE));
    }

    public void addPredicate(Predicate<? super EObject> predicate) {
        boolean changed = this.getPredicates().add(predicate);
        if (changed) {
            this.refreshViewers();
        }
    }

    public void removePredicate(Predicate<? super EObject> predicate) {
        boolean changed = this.getPredicates().remove(predicate);
        if (changed) {
            this.refreshViewers();
        }
    }

    private void refreshViewers() {
        for (TreeViewer viewer : this.viewers) {
            TreePath[] paths = viewer.getExpandedTreePaths();
            viewer.refresh();
            viewer.setExpandedTreePaths(paths);
        }
    }

    public void install(final TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this);
        viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StructureMergeViewerFilter.this.uninstall(viewer);
            }
        });
        this.viewers.add(viewer);
    }

    public void uninstall(TreeViewer viewer) {
        viewer.removeFilter((ViewerFilter)this);
        this.viewers.remove(viewer);
    }

    public Set<Predicate<? super EObject>> getPredicates() {
        return this.predicates;
    }
}

