/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.EventObject;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeInput;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.SubscriberStorageAccessor;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractViewerWrapper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareDiffTreeRuler;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareDiffTreeViewer;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.actions.ActionFactory;

public class EMFCompareStructureMergeViewer
extends AbstractViewerWrapper
implements CommandStackListener {
    private static final int TREE_RULER_WIDTH = 17;
    private ComposedAdapterFactory fAdapterFactory;
    private EMFCompareDiffTreeRuler treeRuler;
    private ICompareInputChangeListener fCompareInputChangeListener;
    private ITreeViewerListener fWrappedTreeListener;
    private IPropertyChangeListener fCompareConfigurationPropertyChangeListener;
    private EMFCompareDiffTreeViewer diffTreeViewer;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private CompareHandlerService fHandlerService;
    private boolean resourcesShouldBeUnload;
    private Job inputChangedTask = new Job("Compute Model Differences"){

        public IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Computing Model Differences", (int)100);
            EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), (IProgressMonitor)subMonitor.newChild(100));
            return Status.OK_STATUS;
        }
    };

    public EMFCompareStructureMergeViewer(Composite parent, CompareConfiguration config) {
        super(parent, config);
        this.inputChangedTask.setPriority(30);
    }

    protected Control createControl(Composite parent, CompareConfiguration config) {
        Composite control = new Composite(parent, 0);
        this.fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().getAdapterFactoryRegistry());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new TreeItemProviderAdapterFactorySpec());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        config.setProperty("org.eclipse.emf.compare.rcp.ui.COMPOSED_ADAPTER_FACTORY", (Object)this.fAdapterFactory);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        GridData data = new GridData(4, 4, true, true);
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)data);
        this.diffTreeViewer = new EMFCompareDiffTreeViewer(control, (AdapterFactory)this.fAdapterFactory, config);
        this.setViewer((StructuredViewer)this.diffTreeViewer);
        control.setData("org.eclipse.compare.internal.Navigator", this.diffTreeViewer.getControl().getData("org.eclipse.compare.internal.Navigator"));
        control.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)"Model differences");
        this.diffTreeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        GridData layoutData = new GridData(4, 4, false, true);
        layoutData.widthHint = 17;
        layoutData.minimumWidth = 17;
        this.treeRuler = new EMFCompareDiffTreeRuler(control, 0, layoutData.widthHint, (TreeViewer)this.diffTreeViewer, config);
        this.treeRuler.setLayoutData(layoutData);
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input);
            }
        };
        this.fWrappedTreeListener = new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }
        };
        this.diffTreeViewer.addTreeListener(this.fWrappedTreeListener);
        this.fCompareConfigurationPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.emf.compare.rcp.ui.MERGE_WAY".equals(event.getProperty()) && event.getNewValue() != null) {
                    EMFCompareStructureMergeViewer.this.diffTreeViewer.configurationPropertyChanged();
                    EMFCompareStructureMergeViewer.this.treeRuler.computeConsequences();
                    EMFCompareStructureMergeViewer.this.treeRuler.redraw();
                } else if ("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS".equals(event.getProperty()) && event.getNewValue() != null) {
                    EMFCompareStructureMergeViewer.this.diffTreeViewer.createChildrenSilently(EMFCompareStructureMergeViewer.this.diffTreeViewer.getTree());
                    EMFCompareStructureMergeViewer.this.treeRuler.computeConsequences();
                    EMFCompareStructureMergeViewer.this.treeRuler.redraw();
                } else if ("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP".equals(event.getProperty()) && event.getNewValue() != null) {
                    EMFCompareStructureMergeViewer.this.diffTreeViewer.createChildrenSilently(EMFCompareStructureMergeViewer.this.diffTreeViewer.getTree());
                    EMFCompareStructureMergeViewer.this.treeRuler.computeConsequences();
                    EMFCompareStructureMergeViewer.this.treeRuler.redraw();
                }
            }
        };
        this.getCompareConfiguration().addPropertyChangeListener(this.fCompareConfigurationPropertyChangeListener);
        this.fHandlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.diffTreeViewer.getControl().getShell());
        return control;
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        super.fireSelectionChanged(event);
        this.treeRuler.selectionChanged(event);
        this.treeRuler.redraw();
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (input instanceof ICompareInput) {
            this.getViewer().setInput(input);
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            TreeItem item = new TreeItem(this.diffTreeViewer.getTree(), 0);
            item.setText("Computing model differences...");
            this.compareInputChanged(ci);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        this.getCompareConfiguration().removePropertyChangeListener(this.fCompareConfigurationPropertyChangeListener);
        this.diffTreeViewer.removeTreeListener(this.fWrappedTreeListener);
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.compareInputChanged(null);
        this.treeRuler.handleDispose();
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    public void commandStackChanged(EventObject event) {
        Command mostRecentCommand;
        if (this.undoAction != null) {
            this.undoAction.update();
        }
        if (this.redoAction != null) {
            this.redoAction.update();
        }
        if ((mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand()) instanceof ICompareCopyCommand) {
            Object first;
            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
            SWTUtil.safeAsyncExec(new Runnable(){

                public void run() {
                    EMFCompareStructureMergeViewer.this.refresh(true);
                    EMFCompareStructureMergeViewer.this.diffTreeViewer.createChildrenSilently(EMFCompareStructureMergeViewer.this.diffTreeViewer.getTree());
                    EMFCompareStructureMergeViewer.this.treeRuler.computeConsequences();
                    EMFCompareStructureMergeViewer.this.treeRuler.redraw();
                }
            });
            if (!affectedObjects.isEmpty() && (first = Iterables.getFirst((Iterable)affectedObjects, null)) instanceof EObject) {
                TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
                treeNode.setData((EObject)first);
                final Adapter adaptedAffectedObject = this.fAdapterFactory.adapt((Notifier)treeNode, ICompareInput.class);
                SWTUtil.safeAsyncExec(new Runnable(){

                    public void run() {
                        EMFCompareStructureMergeViewer.this.setSelectionToWidget((ISelection)new StructuredSelection(adaptedAffectedObject), true);
                    }
                });
            }
        }
    }

    void compareInputChanged(ICompareInput input) {
        if (input == null) {
            this.compareInputChanged((ICompareInput)null, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc != null) {
            this.inputChangedTask.schedule();
        }
    }

    void compareInputChanged(CompareInputAdapter input, IProgressMonitor monitor) {
        ICompareEditingDomain editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
        editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.compareInputChanged(null, (Comparison)input.getComparisonObject());
    }

    void compareInputChanged(ComparisonScopeInput input, IProgressMonitor monitor) {
        ICompareEditingDomain editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
        editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        EMFCompare comparator = (EMFCompare)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.COMPARATOR");
        IComparisonScope comparisonScope = input.getComparisonScope();
        Comparison comparison = comparator.compare(comparisonScope, BasicMonitor.toMonitor((IProgressMonitor)monitor));
        this.reportErrors(comparison);
        this.compareInputChanged(input.getComparisonScope(), comparison);
    }

    void compareInputChanged(final IComparisonScope scope, final Comparison comparison) {
        if (!this.getControl().isDisposed()) {
            IDifferenceGroupProvider selectedGroup = (IDifferenceGroupProvider)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP");
            TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
            treeNode.setData((EObject)comparison);
            if (selectedGroup == null) {
                selectedGroup = this.diffTreeViewer.getDefaultGroupProvider();
            }
            treeNode.eAdapters().add((Object)selectedGroup);
            this.diffTreeViewer.setRoot(this.fAdapterFactory.adapt((Notifier)treeNode, ICompareInput.class));
            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT", (Object)comparison);
            SWTUtil.safeAsyncExec(new Runnable(){

                public void run() {
                    if (EMFCompareStructureMergeViewer.this.diffTreeViewer.getGroupActionMenu() != null) {
                        EMFCompareStructureMergeViewer.this.diffTreeViewer.getGroupActionMenu().createActions(scope, comparison);
                    }
                    if (EMFCompareStructureMergeViewer.this.diffTreeViewer.getFilterActionMenu() != null) {
                        EMFCompareStructureMergeViewer.this.diffTreeViewer.getFilterActionMenu().createActions(scope, comparison);
                    }
                    EMFCompareStructureMergeViewer.this.diffTreeViewer.createChildrenSilently(EMFCompareStructureMergeViewer.this.diffTreeViewer.getTree());
                    EMFCompareStructureMergeViewer.this.diffTreeViewer.refreshAfterDiff(EMFCompareStructureMergeViewer.this.diffTreeViewer.getRoot());
                    EMFCompareStructureMergeViewer.this.diffTreeViewer.initialSelection();
                }
            });
            ICompareEditingDomain editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
            this.undoAction = new UndoAction(editingDomain);
            this.redoAction = new RedoAction(editingDomain);
            this.fHandlerService.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
            this.fHandlerService.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        }
    }

    /*
     * Unable to fully structure code
     */
    void compareInputChanged(ICompareInput input, IProgressMonitor monitor) {
        block15: {
            block16: {
                block14: {
                    if (input == null) break block14;
                    if (input instanceof CompareInputAdapter) {
                        this.resourcesShouldBeUnload = false;
                        this.compareInputChanged((CompareInputAdapter)input, monitor);
                    } else if (input instanceof ComparisonScopeInput) {
                        this.resourcesShouldBeUnload = false;
                        this.compareInputChanged((ComparisonScopeInput)input, monitor);
                    } else {
                        this.resourcesShouldBeUnload = true;
                        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        left = input.getLeft();
                        right = input.getRight();
                        origin = input.getAncestor();
                        scope = this.buildComparisonScope(left, right, origin, (IProgressMonitor)subMonitor.newChild(85));
                        compareResult = EMFCompare.builder().setMatchEngineFactoryRegistry(EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry()).setPostProcessorRegistry(EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry()).build().compare(scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(15)));
                        this.reportErrors(compareResult);
                        leftResourceSet = (ResourceSet)scope.getLeft();
                        rightResourceSet = (ResourceSet)scope.getRight();
                        originResourceSet = (ResourceSet)scope.getOrigin();
                        if (this.getCompareConfiguration() != null) {
                            editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
                            if (editingDomain != null) {
                                editingDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
                                editingDomain.dispose();
                            }
                            editingDomain = EMFCompareEditingDomain.create((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
                            editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
                            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN", (Object)editingDomain);
                        }
                        this.compareInputChanged(scope, compareResult);
                    }
                    break block15;
                }
                leftResourceSet = null;
                rightResourceSet = null;
                originResourceSet = null;
                if (this.diffTreeViewer.getRoot() == null) break block16;
                comparison = (Comparison)((CompareInputAdapter)this.diffTreeViewer.getRoot()).getComparisonObject();
                matchIt = comparison.getMatches().iterator();
                if (!comparison.isThreeWay()) ** GOTO lbl54
                while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null || originResourceSet == null)) {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet == null) {
                        rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
                    }
                    if (originResourceSet != null) continue;
                    originResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getOrigin());
                }
                break block16;
lbl-1000:
                // 1 sources

                {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet != null) continue;
                    rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
lbl54:
                    // 3 sources

                    ** while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null))
                }
            }
            if ((editingDomain = (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN")) != null) {
                editingDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN", null);
                editingDomain.dispose();
                editingDomain = null;
            }
            if (this.resourcesShouldBeUnload) {
                EMFCompareStructureMergeViewer.unload(leftResourceSet);
                EMFCompareStructureMergeViewer.unload(rightResourceSet);
                EMFCompareStructureMergeViewer.unload(originResourceSet);
            }
            if (this.getCompareConfiguration() != null) {
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT", null);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS", null);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP", null);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.MERGE_WAY", null);
                this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SMV_SELECTION", null);
            }
            this.diffTreeViewer.setRoot(null);
        }
    }

    private void reportErrors(final Comparison comparison) {
        if (ComparisonUtil.containsErrors((Comparison)comparison)) {
            SWTUtil.safeAsyncExec(new Runnable(){

                public void run() {
                    DiagnosticDialog.open((Shell)EMFCompareStructureMergeViewer.this.getControl().getShell(), (String)"Comparison report", (String)"Some issues were detected.", (Diagnostic)comparison.getDiagnostic());
                }
            });
        }
    }

    private IComparisonScope buildComparisonScope(ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        Object leftStorage;
        SubscriberStorageAccessor storageAccessor = null;
        if (this.getSubscriber() != null) {
            storageAccessor = new SubscriberStorageAccessor(this.getSubscriber());
        }
        if ((leftStorage = PlatformElementUtil.findFile(left)) == null) {
            leftStorage = StreamAccessorStorage.fromTypedElement(left);
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)leftStorage);
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, new IdenticalResourceMinimizer(), storageAccessor);
        return scopeBuilder.build(left, right, origin, monitor);
    }

    private Subscriber getSubscriber() {
        if (this.getCompareConfiguration().getContainer() instanceof ModelCompareEditorInput) {
            ModelCompareEditorInput modelInput = (ModelCompareEditorInput)this.getCompareConfiguration().getContainer();
            ISynchronizeParticipant participant = null;
            try {
                final Field field = ModelCompareEditorInput.class.getDeclaredField("participant");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                participant = (ISynchronizeParticipant)field.get(modelInput);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (participant instanceof ModelSynchronizeParticipant && ((ModelSynchronizeParticipant)participant).getContext() instanceof SubscriberMergeContext) {
                return ((SubscriberMergeContext)((ModelSynchronizeParticipant)participant).getContext()).getSubscriber();
            }
        }
        return null;
    }

    private static void unload(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                resource.unload();
            }
            resourceSet.getResources().clear();
        }
    }

    private static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            return eResource.getResourceSet();
        }
        return null;
    }
}

