/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.AttributeChangeNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ComparisonNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ConflictNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.DiffNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.EquivalenceNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.MatchNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.MatchResourceNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ReferenceChangeNode;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.ResourceAttachmentChangeNode;
import org.eclipse.emf.compare.util.CompareAdapterFactory;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;

public class CompareNodeAdapterFactory
extends CompareAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected final IChangeNotifier changeNotifier = new ChangeNotifier();
    protected final Collection<Object> supportedTypes = Lists.newArrayList();

    public CompareNodeAdapterFactory() {
        this.supportedTypes.add(ICompareInput.class);
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        CompareNodeAdapterFactory ret = this;
        if (this.parentAdapterFactory != null) {
            ret = this.parentAdapterFactory.getRootAdapterFactory();
        }
        return ret;
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public Adapter createComparisonAdapter() {
        return new ComparisonNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createMatchResourceAdapter() {
        return new MatchResourceNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createMatchAdapter() {
        return new MatchNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createDiffAdapter() {
        return new DiffNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createResourceAttachmentChangeAdapter() {
        return new ResourceAttachmentChangeNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createReferenceChangeAdapter() {
        return new ReferenceChangeNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createAttributeChangeAdapter() {
        return new AttributeChangeNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createConflictAdapter() {
        return new ConflictNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public Adapter createEquivalenceAdapter() {
        return new EquivalenceNode((AdapterFactory)this.getRootAdapterFactory());
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
    }
}

