/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchAccessor
implements ICompareAccessor {
    private final AdapterFactory fAdapterFactory;
    private final Match fMatch;
    private final IMergeViewer.MergeViewerSide fSide;

    public MatchAccessor(AdapterFactory adapterFactory, Match match, IMergeViewer.MergeViewerSide side) {
        this.fAdapterFactory = adapterFactory;
        this.fMatch = match;
        this.fSide = side;
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    @Override
    public String getName() {
        return MergeViewerUtil.getEObject(this.fMatch, this.fSide).eClass().getName();
    }

    @Override
    public Image getImage() {
        EObject eObject = MergeViewerUtil.getEObject(this.fMatch, this.fSide);
        Object image = AdapterFactoryUtil.getImage((AdapterFactory)this.fAdapterFactory, (Object)eObject);
        return ExtendedImageRegistry.getInstance().getImage(image);
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eMatch";
    }

    @Override
    public Comparison getComparison() {
        return this.fMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        return new MergeViewerItem.Container(this.fMatch.getComparison(), null, this.fMatch, this.fSide, this.fAdapterFactory);
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        ImmutableList.Builder ret = ImmutableList.builder();
        EList matches = this.getComparison().getMatches();
        for (Match match : matches) {
            ResourceAttachmentChange diff = (ResourceAttachmentChange)Iterables.getFirst((Iterable)Iterables.filter((Iterable)match.getDifferences(), ResourceAttachmentChange.class), null);
            MergeViewerItem.Container container = null;
            if (this.getSide() == IMergeViewer.MergeViewerSide.ANCESTOR && (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR || match.getOrigin() == null)) continue;
            container = new MergeViewerItem.Container(this.getComparison(), (Diff)diff, match.getLeft(), match.getRight(), match.getOrigin(), this.getSide(), this.fAdapterFactory);
            ret.add((Object)container);
        }
        return ret.build();
    }
}

