/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.req;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReqEngine
implements IReqEngine {
    @Override
    public void computeRequirements(Comparison comparison, Monitor monitor) {
        for (Diff difference : comparison.getDifferences()) {
            this.checkForRequiredDifferences(comparison, difference);
        }
    }

    protected void checkForRequiredDifferences(Comparison comparison, Diff difference) {
        HashSet<ReferenceChange> requiredDifferences = new HashSet<ReferenceChange>();
        HashSet<ReferenceChange> requiredByDifferences = new HashSet<ReferenceChange>();
        Match match = difference.getMatch();
        EObject value = DefaultReqEngine.getValue(comparison, difference);
        DifferenceKind kind = difference.getKind();
        if (value != null) {
            if (kind == DifferenceKind.ADD && DefaultReqEngine.isContainment(difference)) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value.eContainer(), DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDELOriginValueOnContainmentRefSingle(comparison, difference));
            } else if ((kind == DifferenceKind.ADD || DefaultReqEngine.isChangeAdd(comparison, difference)) && !DefaultReqEngine.isContainment(difference)) {
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, DifferenceKind.ADD));
                EObject container = MatchUtil.getContainer(comparison, difference);
                if (container != null) {
                    requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, DifferenceKind.ADD));
                }
                requiredDifferences.addAll(Collections2.filter(match.getDifferences(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), EMFComparePredicates.ofKind(DifferenceKind.ADD))));
            } else if (kind == DifferenceKind.DELETE && DefaultReqEngine.isContainment(difference)) {
                requiredDifferences.addAll(this.getDELOutgoingReferences(comparison, difference));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, (List<EObject>)value.eContents(), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getMOVEContainedObjects(comparison, difference));
            } else if ((kind == DifferenceKind.DELETE || DefaultReqEngine.isChangeDelete(difference)) && !DefaultReqEngine.isContainment(difference)) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, DifferenceKind.DELETE));
            } else if (kind == DifferenceKind.MOVE && DefaultReqEngine.isContainment(difference)) {
                EObject container = value.eContainer();
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, DifferenceKind.ADD));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, container, DifferenceKind.MOVE));
            } else if (kind == DifferenceKind.CHANGE && !DefaultReqEngine.isChangeAdd(comparison, difference) && !DefaultReqEngine.isChangeDelete(difference)) {
                requiredByDifferences.addAll(this.getDifferenceOnGivenObject(comparison, MatchUtil.getOriginValue(comparison, (ReferenceChange)difference), DifferenceKind.DELETE));
                requiredDifferences.addAll(this.getDifferenceOnGivenObject(comparison, value, DifferenceKind.ADD));
            }
            difference.getRequires().addAll(requiredDifferences);
            difference.getRequiredBy().addAll(requiredByDifferences);
        }
    }

    private Set<ReferenceChange> getDELOriginValueOnContainmentRefSingle(Comparison comparison, Diff sourceDifference) {
        Object originValue;
        EObject originContainer;
        Set<ReferenceChange> result = new HashSet<ReferenceChange>();
        if (!(sourceDifference instanceof ReferenceChange)) {
            return result;
        }
        EReference reference = ((ReferenceChange)sourceDifference).getReference();
        if (!reference.isMany() && (originContainer = MatchUtil.getOriginContainer(comparison, sourceDifference)) != null && (originValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)reference)) instanceof EObject) {
            result = this.getDifferenceOnGivenObject(comparison, (EObject)originValue, DifferenceKind.DELETE);
        }
        return result;
    }

    private Set<ReferenceChange> getDifferenceOnGivenObject(Comparison comparison, EObject object, DifferenceKind kind) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        for (ReferenceChange diff : Iterables.filter(comparison.getDifferences(object), ReferenceChange.class)) {
            if (diff.getKind() != kind || !diff.getReference().isContainment()) continue;
            result.add(diff);
        }
        return result;
    }

    private Set<ReferenceChange> getDifferenceOnGivenObject(Comparison comparison, List<EObject> objects, DifferenceKind kind) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        for (EObject object : objects) {
            result.addAll(this.getDifferenceOnGivenObject(comparison, object, kind));
        }
        return result;
    }

    private Set<ReferenceChange> getDELOutgoingReferences(Comparison comparison, Diff sourceDifference) {
        Match valueMatch;
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        EObject value = DefaultReqEngine.getValue(comparison, sourceDifference);
        if (value != null && (valueMatch = comparison.getMatch(value)) != null) {
            for (ReferenceChange candidate : Iterables.filter(valueMatch.getDifferences(), ReferenceChange.class)) {
                if (candidate.getKind() != DifferenceKind.DELETE && !DefaultReqEngine.isChangeDelete(candidate)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private Set<ReferenceChange> getMOVEContainedObjects(Comparison comparison, Diff sourceDifference) {
        HashSet<ReferenceChange> result = new HashSet<ReferenceChange>();
        EObject value = DefaultReqEngine.getValue(comparison, sourceDifference);
        if (value != null) {
            EList contents = value.eContents();
            for (EObject content : contents) {
                EObject originObject = MatchUtil.getOriginObject(comparison, content);
                if (originObject == null) continue;
                for (ReferenceChange difference : Iterables.filter(comparison.getDifferences(originObject), ReferenceChange.class)) {
                    if (!difference.getReference().isContainment() || difference.getKind() != DifferenceKind.MOVE) continue;
                    result.add(difference);
                }
            }
        }
        return result;
    }

    private static boolean isChangeAdd(Comparison comparison, Diff difference) {
        EReference reference;
        boolean result = false;
        if (difference instanceof ReferenceChange && !(reference = ((ReferenceChange)difference).getReference()).isMany() && !reference.isContainment()) {
            EObject right;
            EObject origin;
            Match match = difference.getMatch();
            result = comparison.isThreeWay() ? (origin = match.getOrigin()) == null || ReferenceUtil.safeEGet(origin, (EStructuralFeature)reference) == null : (right = match.getRight()) == null || ReferenceUtil.safeEGet(right, (EStructuralFeature)reference) == null;
        }
        return result;
    }

    private static boolean isChangeDelete(Diff difference) {
        EReference reference;
        boolean result = false;
        if (difference instanceof ReferenceChange && !(reference = ((ReferenceChange)difference).getReference()).isMany() && !reference.isContainment()) {
            EObject right;
            EObject left;
            Match match = difference.getMatch();
            result = difference.getSource() == DifferenceSource.LEFT ? (left = match.getLeft()) == null || ReferenceUtil.safeEGet(left, (EStructuralFeature)reference) == null : (right = match.getRight()) == null || ReferenceUtil.safeEGet(right, (EStructuralFeature)reference) == null;
        }
        return result;
    }

    private static boolean isContainment(Diff diff) {
        return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() || diff instanceof ResourceAttachmentChange;
    }

    private static EObject getValue(Comparison comparison, Diff diff) {
        EObject value = null;
        if (diff instanceof ReferenceChange) {
            value = ((ReferenceChange)diff).getValue();
        } else if (diff instanceof ResourceAttachmentChange) {
            value = MatchUtil.getContainer(comparison, diff);
        }
        return value;
    }
}

