/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.ecore.EReference;

public class PseudoConflictMerger
extends AbstractMerger {
    public boolean isMergerFor(Diff target) {
        return target.getConflict() != null && target.getConflict().getKind() == ConflictKind.PSEUDO;
    }

    public void copyLeftToRight(Diff target, Monitor monitor) {
        boolean continueMerge;
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        ReferenceChange diff = (ReferenceChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null && !(continueMerge = this.handleEquivalences(diff, false, monitor))) {
            return;
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(diff, false, monitor);
        } else {
            this.mergeRequiredBy(diff, false, monitor);
        }
    }

    public void copyRightToLeft(Diff target, Monitor monitor) {
        boolean continueMerge;
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        ReferenceChange diff = (ReferenceChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null && !(continueMerge = this.handleEquivalences(diff, true, monitor))) {
            return;
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(diff, true, monitor);
        } else {
            this.mergeRequires(diff, true, monitor);
        }
    }

    protected boolean handleEquivalences(ReferenceChange diff, boolean rightToLeft, Monitor monitor) {
        EReference reference = diff.getReference();
        boolean continueMerge = true;
        for (Diff equivalent : diff.getEquivalence().getDifferences()) {
            if (equivalent instanceof ReferenceChange && reference.getEOpposite() == ((ReferenceChange)equivalent).getReference() && equivalent.getState() == DifferenceState.UNRESOLVED) {
                boolean mergeEquivalence;
                boolean bl = mergeEquivalence = !reference.isMany() && ((ReferenceChange)equivalent).getReference().isMany();
                if (mergeEquivalence) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                }
            } else if (diff.getSource() == DifferenceSource.LEFT) {
                if (rightToLeft && diff.getRequiredBy().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                } else if (!rightToLeft && diff.getRequires().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                }
            } else if (diff.getSource() == DifferenceSource.RIGHT) {
                if (rightToLeft && diff.getRequires().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                } else if (!rightToLeft && diff.getRequiredBy().contains((Object)equivalent)) {
                    this.mergeDiff(equivalent, rightToLeft, monitor);
                    continueMerge = false;
                }
            }
            equivalent.setState(DifferenceState.MERGED);
        }
        return continueMerge;
    }
}

