/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.AbstractDifferenceFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMFRefinedElementsFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            if (input instanceof Diff) {
                Diff diff = (Diff)input;
                return Iterables.any((Iterable)diff.getRefines(), (Predicate)Predicates.instanceOf(DiagramDiff.class));
            }
            return false;
        }
    };
    private static final Predicate<? super EObject> PREDICATE_WHEN_UNSELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            EPackage p = input.eClass().getEPackage();
            if (p != null) {
                return p.getNsURI().startsWith("http://www.eclipse.org/emf/compare/diagram");
            }
            return false;
        }
    };

    public boolean isEnabled(IComparisonScope scope, Comparison comparison) {
        if (scope != null) {
            for (String nsURI : scope.getNsURIs()) {
                if (!nsURI.matches("http://www\\.eclipse\\.org/gmf/runtime/.*/notation")) continue;
                return true;
            }
        }
        return false;
    }

    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }

    public Predicate<? super EObject> getPredicateWhenUnselected() {
        return PREDICATE_WHEN_UNSELECTED;
    }
}

