/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AttributeChangeMerger
extends AbstractMerger {
    public boolean isMergerFor(Diff target) {
        return target instanceof AttributeChange;
    }

    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        AttributeChange diff = (AttributeChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null) {
            for (Diff equivalent : diff.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(diff, false, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.addInTarget(diff, false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(diff, false);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, false);
                    break;
                }
                case CHANGE: {
                    this.changeValue(diff, false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(diff, false, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.removeFromTarget(diff, false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(diff, false);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, false);
                    break;
                }
                case CHANGE: {
                    this.changeValue(diff, false);
                    break;
                }
            }
        }
    }

    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        AttributeChange diff = (AttributeChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null) {
            for (Diff equivalent : diff.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(diff, true, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.removeFromTarget(diff, true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(diff, true);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, true);
                    break;
                }
                case CHANGE: {
                    this.changeValue(diff, true);
                    break;
                }
            }
        } else {
            this.mergeRequires(diff, true, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.addInTarget(diff, true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(diff, true);
                    break;
                }
                case MOVE: {
                    this.moveElement(diff, true);
                    break;
                }
                case CHANGE: {
                    this.changeValue(diff, true);
                    break;
                }
            }
        }
    }

    protected void addInTarget(AttributeChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        if (expectedContainer != null) {
            Comparison comparison = match.getComparison();
            EAttribute attribute = diff.getAttribute();
            Object expectedValue = diff.getValue();
            if (attribute.isMany()) {
                int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
                List targetList = (List)expectedContainer.eGet((EStructuralFeature)attribute);
                this.addAt(targetList, expectedValue, insertionIndex);
            } else {
                expectedContainer.eSet((EStructuralFeature)attribute, expectedValue);
            }
        }
    }

    protected void removeFromTarget(AttributeChange diff, boolean rightToLeft) {
        EObject currentContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        if (currentContainer != null) {
            Object expectedValue = diff.getValue();
            EAttribute attribute = diff.getAttribute();
            if (attribute.isMany()) {
                List targetList = (List)currentContainer.eGet((EStructuralFeature)attribute);
                targetList.remove(expectedValue);
            } else {
                currentContainer.eUnset((EStructuralFeature)attribute);
            }
        }
    }

    protected void moveElement(AttributeChange diff, boolean rightToLeft) {
        EObject expectedContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        if (expectedContainer != null) {
            Comparison comparison = diff.getMatch().getComparison();
            Object expectedValue = diff.getValue();
            this.doMove(diff, comparison, expectedContainer, expectedValue, rightToLeft);
        }
    }

    protected void doMove(AttributeChange diff, Comparison comparison, EObject expectedContainer, Object expectedValue, boolean rightToLeft) {
        EAttribute attribute = diff.getAttribute();
        if (attribute.isMany()) {
            List targetList;
            int currentIndex;
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            if (insertionIndex > (currentIndex = (targetList = (List)expectedContainer.eGet((EStructuralFeature)attribute)).indexOf(expectedValue))) {
                --insertionIndex;
            }
            if (targetList instanceof EList) {
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    ((EList)targetList).move(targetList.size() - 1, expectedValue);
                } else {
                    ((EList)targetList).move(insertionIndex, expectedValue);
                }
            } else {
                targetList.remove(expectedValue);
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    targetList.add(expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            }
        } else {
            expectedContainer.eSet((EStructuralFeature)attribute, expectedValue);
        }
    }

    protected void resetInTarget(AttributeChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EAttribute attribute = diff.getAttribute();
        EObject targetContainer = rightToLeft ? match.getLeft() : match.getRight();
        EObject originContainer = match.getComparison().isThreeWay() ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        if (originContainer == null || !ReferenceUtil.safeEIsSet(targetContainer, (EStructuralFeature)attribute) || !ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)attribute)) {
            targetContainer.eUnset((EStructuralFeature)attribute);
        } else {
            Object expectedValue = originContainer.eGet((EStructuralFeature)attribute);
            targetContainer.eSet((EStructuralFeature)attribute, expectedValue);
        }
    }

    protected void changeValue(AttributeChange diff, boolean rightToLeft) {
        boolean isUnset;
        boolean resetToOrigin;
        Match match = diff.getMatch();
        EAttribute attribute = diff.getAttribute();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        boolean bl = resetToOrigin = diff.getSource() == DifferenceSource.LEFT && rightToLeft || diff.getSource() == DifferenceSource.RIGHT && !rightToLeft;
        EObject originContainer = resetToOrigin && match.getComparison().isThreeWay() ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        Object targetValue = ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)attribute);
        Object defaultValue = attribute.getDefaultValue();
        boolean bl2 = isUnset = targetValue == null || targetValue.equals(defaultValue) || defaultValue == null && "".equals(targetValue);
        if (isUnset) {
            expectedContainer.eUnset((EStructuralFeature)attribute);
        } else {
            expectedContainer.eSet((EStructuralFeature)attribute, targetValue);
        }
    }

    protected int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        return DiffUtil.findInsertionIndex(comparison, diff, rightToLeft);
    }
}

