/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;

public class ReflectiveWeightProvider
implements WeightProvider {
    private Map<EStructuralFeature, Integer> weights = Maps.newHashMap();
    private Set<EStructuralFeature> toBeIgnored = Sets.newLinkedHashSet();
    private int referenceChangeCoef = 2;
    private int attributeChangeCoef = 5;

    public int getWeight(EStructuralFeature feature) {
        if (this.irrelevant(feature) || this.toBeIgnored.contains(feature)) {
            return 0;
        }
        Integer found = this.weights.get(feature);
        if (found == null) {
            found = 1;
            if ("name".equals(feature.getName()) || "id".equals(feature.getName())) {
                found = 4;
            }
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                found = 2;
            }
        }
        found = feature instanceof EReference ? Integer.valueOf(this.referenceChangeCoef * found) : Integer.valueOf(this.attributeChangeCoef * found);
        return found;
    }

    protected boolean irrelevant(EStructuralFeature feat) {
        boolean irrelevantFeature;
        boolean bl = irrelevantFeature = feat.isDerived() || feat.isTransient();
        if (!irrelevantFeature && feat instanceof EReference) {
            EReference ref = (EReference)feat;
            irrelevantFeature = ref.isContainment() || ref.isContainer();
        }
        return irrelevantFeature;
    }

    public int getParentWeight(EObject a) {
        if (a instanceof EStructuralFeature) {
            return 34;
        }
        if (a instanceof EAnnotation) {
            return 34;
        }
        if (a instanceof EOperation) {
            return 20;
        }
        if (a instanceof EParameter) {
            return 30;
        }
        if (a instanceof EStringToStringMapEntryImpl) {
            return 30;
        }
        return 1;
    }

    public int getContainingFeatureWeight(EObject a) {
        if (a instanceof EStructuralFeature || a instanceof EAnnotation || a instanceof EOperation) {
            return 20;
        }
        return 1;
    }
}

