/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.extension.PostProcessorRegistry;
import org.eclipse.emf.compare.extension.merge.IMerger;
import org.eclipse.emf.compare.ide.internal.extension.PostProcessorRegistryListener;
import org.eclipse.emf.compare.ide.internal.policy.LoadOnDemandPolicyRegistryImpl;
import org.eclipse.emf.compare.ide.internal.policy.LoadOnDemandPolicyRegistryListener;
import org.eclipse.emf.compare.ide.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.compare.ide.utils.AbstractRegistryEventListener;
import org.osgi.framework.BundleContext;

public class EMFCompareIDEPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.compare.ide";
    public static final String LOAD_ON_DEMAND_POLICY_PPID = "load_on_demand_policy";
    public static final String MERGER_EXTENSION_PPID = "mergerExtension";
    private static final String COMPARE_PLUGIN_ID = "org.eclipse.emf.compare";
    private static EMFCompareIDEPlugin plugin;
    private PostProcessorRegistry postProcessorRegistry;
    private PostProcessorRegistryListener postProcessorListener;
    private ILoadOnDemandPolicy.Registry loadOnDemandRegistry;
    private LoadOnDemandPolicyRegistryListener loadOnDemandRegistryListener;
    private AbstractRegistryEventListener mergerRegistryListener;
    private IMerger.Registry mergerRegistry;

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.postProcessorRegistry = new PostProcessorRegistry();
        this.postProcessorListener = new PostProcessorRegistryListener(this.postProcessorRegistry);
        registry.addListener((IRegistryEventListener)this.postProcessorListener, "org.eclipse.emf.compare.postProcessor");
        this.postProcessorListener.parseInitialContributions();
        this.loadOnDemandRegistry = new LoadOnDemandPolicyRegistryImpl();
        this.loadOnDemandRegistryListener = new LoadOnDemandPolicyRegistryListener(this.loadOnDemandRegistry, PLUGIN_ID, LOAD_ON_DEMAND_POLICY_PPID);
        registry.addListener((IRegistryEventListener)this.loadOnDemandRegistryListener, "org.eclipse.emf.compare.ide.load_on_demand_policy");
        this.loadOnDemandRegistryListener.readRegistry(registry);
        this.mergerRegistry = new IMerger.RegistryImpl();
        this.mergerRegistryListener = new MergerExtensionRegistryListener(COMPARE_PLUGIN_ID, MERGER_EXTENSION_PPID);
        registry.addListener((IRegistryEventListener)this.mergerRegistryListener, "org.eclipse.emf.compare.mergerExtension");
        this.mergerRegistryListener.readRegistry(registry);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeListener((IRegistryEventListener)this.loadOnDemandRegistryListener);
        registry.removeListener((IRegistryEventListener)this.postProcessorListener);
    }

    public PostProcessorRegistry getPostProcessorRegistry() {
        return this.postProcessorRegistry;
    }

    public IMerger.Registry getMergerRegistry() {
        return this.mergerRegistry;
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public ILoadOnDemandPolicy.Registry getLoadOnDemandPolicyRegistry() {
        return this.loadOnDemandRegistry;
    }

    public static EMFCompareIDEPlugin getDefault() {
        return plugin;
    }

    private class MergerExtensionRegistryListener
    extends AbstractRegistryEventListener {
        static final String TAG_MERGER = "merger";
        static final String ATT_CLASS = "class";
        static final String ATT_RANKING = "ranking";

        public MergerExtensionRegistryListener(String pluginID, String extensionPointID) {
            super(pluginID, extensionPointID);
        }

        protected boolean readElement(IConfigurationElement element, AbstractRegistryEventListener.Action b) {
            if (element.getName().equals(TAG_MERGER)) {
                if (element.getAttribute(ATT_CLASS) == null) {
                    this.logMissingAttribute(element, ATT_CLASS);
                } else if (element.getAttribute(ATT_RANKING) == null) {
                    String rankingStr = element.getAttribute(ATT_RANKING);
                    try {
                        Integer.parseInt(rankingStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logError(element, "Attribute 'ranking' is malformed, should be an integer.");
                    }
                    this.logMissingAttribute(element, ATT_RANKING);
                } else {
                    switch (b) {
                        case ADD: {
                            try {
                                IMerger merger = (IMerger)element.createExecutableExtension(ATT_CLASS);
                                merger.setRanking(Integer.parseInt(element.getAttribute(ATT_RANKING)));
                                IMerger previous = EMFCompareIDEPlugin.this.mergerRegistry.add(merger);
                                if (previous == null) break;
                                EMFCompareIDEPlugin.this.log(2, "The factory '" + merger.getClass().getName() + "' is registered twice.");
                            }
                            catch (CoreException e) {
                                this.logError(element, e.getMessage());
                            }
                            break;
                        }
                        case REMOVE: {
                            EMFCompareIDEPlugin.this.mergerRegistry.remove(element.getAttribute(ATT_CLASS));
                            break;
                        }
                    }
                    return true;
                }
            }
            return false;
        }

        protected void logError(IConfigurationElement element, String string) {
            EMFCompareIDEPlugin.this.log(4, string);
        }
    }
}

