/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.MatchResourceItemProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public class MatchResourceItemProviderSpec
extends MatchResourceItemProvider
implements IItemStyledLabelProvider {
    public MatchResourceItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        MatchResource matchResource = (MatchResource)object;
        String leftURI = matchResource.getLeftURI();
        String rightURI = matchResource.getRightURI();
        String commonBase = this.getCommonBase(leftURI, rightURI);
        String text = "";
        if (leftURI != null) {
            text = String.valueOf(text) + leftURI.substring(commonBase.length());
        }
        text = String.valueOf(text) + " <-> ";
        if (rightURI != null) {
            text = String.valueOf(text) + rightURI.substring(commonBase.length());
        }
        if (matchResource.eContainer() instanceof Comparison && ((Comparison)matchResource.eContainer()).isThreeWay()) {
            String originURI = matchResource.getOriginURI();
            text = String.valueOf(text) + " (" + originURI.substring(commonBase.length()) + ")";
        }
        return text;
    }

    public Object getImage(Object object) {
        MatchResource matchResource = (MatchResource)object;
        Resource resource = matchResource.getLeft();
        if (resource == null && (resource = matchResource.getRight()) == null) {
            resource = matchResource.getOrigin();
        }
        if (resource != null) {
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.getRootAdapterFactory().adapt((Notifier)resource, IItemLabelProvider.class);
            Object image = itemLabelProvider.getImage((Object)resource);
            if (image != null) {
                return image;
            }
            return super.getImage(object);
        }
        return super.getImage(object);
    }

    public String getCommonBase(String left, String right) {
        if (left == null || right == null) {
            return "";
        }
        char[] leftChars = left.toCharArray();
        char[] rightChars = right.toCharArray();
        StringBuilder buffer = new StringBuilder();
        StringBuilder fragmentBuffer = new StringBuilder();
        int i = 0;
        while (i < Math.min(leftChars.length, rightChars.length)) {
            if (leftChars[i] != rightChars[i]) break;
            fragmentBuffer.append(leftChars[i]);
            if (leftChars[i] == '\\' || leftChars[i] == '/') {
                buffer.append((CharSequence)fragmentBuffer);
                fragmentBuffer = new StringBuilder();
            }
            ++i;
        }
        return buffer.toString();
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        return new ComposedStyledString(this.getText(object));
    }
}

