/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchItemProviderSpec
extends MatchItemProvider
implements IItemStyledLabelProvider {
    private static final Predicate<ReferenceChange> CONTAINMENT_REFERENCE_CHANGE = new Predicate<ReferenceChange>(){

        public boolean apply(ReferenceChange input) {
            return input.getReference().isContainment();
        }
    };
    private static final Function<ReferenceChange, EObject> VALUE = new Function<ReferenceChange, EObject>(){

        public EObject apply(ReferenceChange input) {
            return input.getValue();
        }
    };
    private final OverlayImageProvider overlayProvider = new OverlayImageProvider(this.getResourceLocator(), true);
    static final Predicate<? super Object> REFINED_DIFF = new Predicate<Object>(){

        public boolean apply(Object input) {
            boolean ret = false;
            if (input instanceof Diff) {
                Diff diff = (Diff)input;
                ret = !diff.getRefines().isEmpty();
            }
            return ret;
        }
    };
    private static final Predicate<? super Object> PSEUDO_CONFLICT_DIFF = new Predicate<Object>(){

        public boolean apply(Object input) {
            Diff diff;
            Conflict conflict;
            boolean ret = false;
            if (input instanceof Diff && (conflict = (diff = (Diff)input).getConflict()) != null && conflict.getKind() == ConflictKind.PSEUDO) {
                ret = true;
            }
            return ret;
        }
    };
    private static final Predicate<? super Object> PSEUDO_DELETE_CONFLICT = new Predicate<Object>(){

        public boolean apply(Object input) {
            ReferenceChange referenceChange;
            Conflict conflict;
            boolean ret = false;
            if (input instanceof ReferenceChange && (conflict = (referenceChange = (ReferenceChange)input).getConflict()) != null) {
                EReference eReference = referenceChange.getReference();
                EObject value = referenceChange.getValue();
                Iterable conflictualReferenceChanges = Iterables.filter((Iterable)conflict.getDifferences(), ReferenceChange.class);
                for (ReferenceChange conflictualReferenceChange : conflictualReferenceChanges) {
                    if (conflictualReferenceChange == referenceChange || conflictualReferenceChange.getReference() != eReference || conflictualReferenceChange.getValue() != value) continue;
                    ret = true;
                }
            }
            return ret;
        }
    };

    public MatchItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object getImage(Object object) {
        Match match = (Match)object;
        Object ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage(match, ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    @Override
    public String getText(Object object) {
        Match match = (Match)object;
        String ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getText(object);
        }
        return ret;
    }

    public Collection<?> getChildren(Object object) {
        Match match = (Match)object;
        Iterable<?> filteredChildren = this.getChildrenIterable(match);
        return ImmutableList.copyOf(filteredChildren);
    }

    Iterable<?> getChildrenIterable(Match match) {
        ImmutableSet<EObject> containementDifferenceValues = this.containmentReferencesValues(match);
        Predicate childrenFilter = Predicates.not((Predicate)Predicates.or((Predicate[])new Predicate[]{MatchItemProviderSpec.matchOfContainmentDiff(containementDifferenceValues), this.matchWithNoChildren(), MatchItemProviderSpec.emptyMatch(), PSEUDO_CONFLICT_DIFF, REFINED_DIFF, PSEUDO_DELETE_CONFLICT}));
        Iterable filteredChildren = Iterables.filter((Iterable)super.getChildren((Object)match), (Predicate)childrenFilter);
        return filteredChildren;
    }

    private ImmutableSet<EObject> containmentReferencesValues(Match match) {
        EList differences = match.getDifferences();
        Iterable containmentReferenceChanges = Iterables.filter((Iterable)Iterables.filter((Iterable)differences, ReferenceChange.class), CONTAINMENT_REFERENCE_CHANGE);
        ImmutableSet containementDifferenceValues = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)containmentReferenceChanges, VALUE));
        return containementDifferenceValues;
    }

    private static Predicate<? super Object> matchOfContainmentDiff(final ImmutableSet<EObject> containementDifferenceValues) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                Match match;
                boolean ret = false;
                if (input instanceof Match && (containementDifferenceValues.contains((Object)(match = (Match)input).getLeft()) || containementDifferenceValues.contains((Object)match.getRight()) || containementDifferenceValues.contains((Object)match.getOrigin()))) {
                    ret = true;
                }
                return ret;
            }
        };
    }

    private Predicate<? super Object> matchWithNoChildren() {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                boolean ret = false;
                if (input instanceof Match) {
                    Match match = (Match)input;
                    ret = Iterables.isEmpty(MatchItemProviderSpec.this.getChildrenIterable(match));
                }
                return ret;
            }
        };
    }

    private static Predicate<? super Object> emptyMatch() {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                if (input instanceof Match) {
                    Match match = (Match)input;
                    return match.getLeft() == null && match.getRight() == null && match.getOrigin() == null;
                }
                return false;
            }
        };
    }

    public boolean hasChildren(Object object) {
        Match match = (Match)object;
        return !Iterables.isEmpty(this.getChildrenIterable(match));
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        return new ComposedStyledString(this.getText(object));
    }
}

