/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDifferenceFilter {
    public Predicate<? super EObject> getPredicate();

    public String getLabel();

    public void setLabel(String var1);

    public boolean defaultSelected();

    public void setDefaultSelected(boolean var1);

    public boolean isEnabled(IComparisonScope var1, Comparison var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public Collection<IDifferenceFilter> getFilters(IComparisonScope var1, Comparison var2);

        public IDifferenceFilter add(IDifferenceFilter var1);

        public IDifferenceFilter remove(String var1);

        public void clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegistryImpl
    implements Registry {
        private final Map<String, IDifferenceFilter> map = new ConcurrentHashMap<String, IDifferenceFilter>();

        public List<IDifferenceFilter> getFilters(IComparisonScope scope, Comparison comparison) {
            Iterable filters = Iterables.filter(this.map.values(), RegistryImpl.isFilterActivable(scope, comparison));
            ArrayList ret = Lists.newArrayList();
            for (IDifferenceFilter filter : filters) {
                ret.add(filter);
            }
            return ret;
        }

        static final Predicate<IDifferenceFilter> isFilterActivable(final IComparisonScope scope, final Comparison comparison) {
            return new Predicate<IDifferenceFilter>(){

                public boolean apply(IDifferenceFilter d) {
                    return d.isEnabled(scope, comparison);
                }
            };
        }

        @Override
        public IDifferenceFilter add(IDifferenceFilter filter) {
            Preconditions.checkNotNull((Object)filter);
            return this.map.put(filter.getClass().getName(), filter);
        }

        @Override
        public IDifferenceFilter remove(String className) {
            return this.map.remove(className);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

