/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;

public abstract class AbstractRegistryEventListener
implements IRegistryEventListener {
    private final String pluginID;
    private final String extensionPointID;

    public AbstractRegistryEventListener(String pluginID, String extensionPointID) {
        this.pluginID = pluginID;
        this.extensionPointID = extensionPointID;
    }

    public void readRegistry(IExtensionRegistry extensionRegistry) {
        IExtensionPoint point = extensionRegistry.getExtensionPoint(this.pluginID, this.extensionPointID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.internalReadElement(elements[i], Action.ADD);
                ++i;
            }
        }
    }

    protected abstract boolean readElement(IConfigurationElement var1, Action var2);

    private void internalReadElement(IConfigurationElement element, Action action) {
        boolean recognized = this.readElement(element, action);
        if (recognized) {
            IConfigurationElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.internalReadElement(children[i], action);
                ++i;
            }
        } else {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "The required attribute '" + attributeName + "' not defined");
    }

    protected abstract void logError(IConfigurationElement var1, String var2);

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointID)) {
                IConfigurationElement[] configurationElement = extension.getConfigurationElements();
                int j = 0;
                while (j < configurationElement.length) {
                    this.internalReadElement(configurationElement[j], Action.ADD);
                    ++j;
                }
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointID)) {
                IConfigurationElement[] configurationElement = extension.getConfigurationElements();
                int j = 0;
                while (j < configurationElement.length) {
                    this.internalReadElement(configurationElement[j], Action.REMOVE);
                    ++j;
                }
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Action {
        ADD,
        REMOVE;

    }

    public static class PluginClassDescriptor {
        protected IConfigurationElement element;
        protected String attributeName;

        public PluginClassDescriptor(IConfigurationElement element, String attributeName) {
            this.element = element;
            this.attributeName = attributeName;
        }

        public Object createInstance() {
            try {
                return this.element.createExecutableExtension(this.attributeName);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

