/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diff.internal.extension;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.diagram.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDiffExtensionFactory
implements IDiffExtensionFactory {
    private CompareSwitch<DifferenceKind> differenceKindCompareSwitch = new CompareSwitch<DifferenceKind>(){

        public DifferenceKind caseAttributeChange(AttributeChange object) {
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseAttributeChange(object);
        }

        public DifferenceKind caseReferenceChange(ReferenceChange object) {
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseReferenceChange(object);
        }

        public DifferenceKind caseResourceAttachmentChange(ResourceAttachmentChange object) {
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionAdd(object)) {
                return DifferenceKind.ADD;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionDelete(object)) {
                return DifferenceKind.DELETE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionChange(object)) {
                return DifferenceKind.CHANGE;
            }
            if (AbstractDiffExtensionFactory.this.isRelatedToAnExtensionMove(object)) {
                return DifferenceKind.MOVE;
            }
            return (DifferenceKind)super.caseResourceAttachmentChange(object);
        }
    };

    @Override
    public boolean handles(Diff input) {
        return this.getRelatedExtensionKind(input) != null && !this.isDiffOnAddOrDelete(input);
    }

    @Override
    public Match getParentMatch(Diff input) {
        return input.getMatch();
    }

    protected boolean isDiffOnAddOrDelete(Diff input) {
        Match match = input.getMatch();
        EObject container = match.eContainer();
        if (container instanceof Match) {
            for (Diff diff : ((Match)container).getAllDifferences()) {
                if (!(diff instanceof ReferenceChange) || !this.isRelatedToAnExtensionAdd((ReferenceChange)diff) && !this.isRelatedToAnExtensionDelete((ReferenceChange)diff) || match.getComparison().getMatch(((ReferenceChange)diff).getValue()) != match) continue;
                return true;
            }
        }
        return false;
    }

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return (DifferenceKind)this.differenceKindCompareSwitch.doSwitch((EObject)input);
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ResourceAttachmentChange input) {
        return false;
    }

    @Override
    public Class<? extends Diff> getExtensionKind() {
        return Diff.class;
    }

    protected Set<Diff> getAllContainedDifferences(ReferenceChange input) {
        Comparison comparison = input.getMatch().getComparison();
        Match match = comparison.getMatch(input.getValue());
        Set<Diff> result = this.getAllContainedDifferences(comparison, match);
        return result;
    }

    private Set<Diff> getAllContainedDifferences(Comparison comparison, Match match) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        LinkedHashSet prune = Sets.newLinkedHashSet();
        for (Diff candidate : match.getDifferences()) {
            if (this.getExtensionKind().isInstance(candidate)) continue;
            if (!(candidate instanceof ReferenceChange) || !this.isRelatedToAnExtensionAdd((ReferenceChange)candidate) && !this.isRelatedToAnExtensionDelete((ReferenceChange)candidate)) {
                result.add(candidate);
                continue;
            }
            if (!(candidate instanceof ReferenceChange) || !((ReferenceChange)candidate).getReference().isContainment()) continue;
            prune.add(comparison.getMatch(((ReferenceChange)candidate).getValue()));
        }
        for (Match submatch : match.getSubmatches()) {
            if (prune.contains(submatch)) continue;
            result.addAll(this.getAllContainedDifferences(comparison, submatch));
        }
        return result;
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
    }

    protected final List<Diff> findCrossReferences(Comparison comparison, EObject lookup, Predicate<Diff> p) {
        ArrayList<Diff> result = new ArrayList<Diff>();
        for (Diff diff : comparison.getDifferences(lookup)) {
            if (!p.apply((Object)diff)) continue;
            result.add(diff);
        }
        return result;
    }

    protected View getViewContainer(Diff input) {
        Match match = input.getMatch();
        return this.getViewContainer(match, input.getSource());
    }

    protected View getViewContainer(Match match, DifferenceSource source) {
        EObject result = match.getLeft();
        if (result == null) {
            result = match.getRight();
        }
        if (result instanceof View && ReferenceUtil.safeEGet((EObject)result, (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null) {
            return (View)result;
        }
        if (match.eContainer() instanceof Match) {
            return this.getViewContainer((Match)match.eContainer(), source);
        }
        return null;
    }
}

