/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diff;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.DiagramDiff;
import org.eclipse.emf.compare.diagram.diff.DiagramComparisonConfiguration;
import org.eclipse.emf.compare.diagram.diff.internal.extension.DiffExtensionFactoryRegistry;
import org.eclipse.emf.compare.diagram.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.compare.extension.IPostProcessor;

public class DiagramDiffExtensionPostProcessor
implements IPostProcessor {
    private Set<IDiffExtensionFactory> diagramExtensionFactories;
    private DiagramComparisonConfiguration configuration;

    public DiagramDiffExtensionPostProcessor() {
    }

    public DiagramDiffExtensionPostProcessor(DiagramComparisonConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setConfiguration(DiagramComparisonConfiguration configuration) {
        this.configuration = configuration;
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
        Map<Class<? extends Diff>, IDiffExtensionFactory> mapDiagramExtensionFactories = DiffExtensionFactoryRegistry.createExtensionFactories(this.configuration);
        this.diagramExtensionFactories = new HashSet<IDiffExtensionFactory>(mapDiagramExtensionFactories.values());
        for (Diff diff : comparison.getDifferences()) {
            this.applyManagedTypes(diff);
        }
        for (Diff diff : comparison.getDifferences()) {
            Class classDiffElement;
            IDiffExtensionFactory diffFactory;
            if (!(diff instanceof DiagramDiff) || (diffFactory = mapDiagramExtensionFactories.get(classDiffElement = diff.eClass().getInstanceClass())) == null) continue;
            diffFactory.fillRequiredDifferences(comparison, diff);
        }
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    private void applyManagedTypes(Diff element) {
        for (IDiffExtensionFactory factory : this.diagramExtensionFactories) {
            if (!factory.handles(element)) continue;
            Diff extension = factory.create(element);
            Match match = factory.getParentMatch(element);
            match.getDifferences().add((Object)extension);
        }
    }
}

