/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer;

import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class StructuredMergeViewer
extends MergeViewer {
    private final Control fControl;
    private final ISelectionChangedListener fForwardingSelectionListener;

    public StructuredMergeViewer(Composite parent, MergeViewer.MergeViewerSide side) {
        super(side);
        this.fControl = this.createControl(parent);
        this.hookControl(this.fControl);
        this.fForwardingSelectionListener = new ForwardingViewerSelectionListener();
        this.getStructuredViewer().addSelectionChangedListener(this.fForwardingSelectionListener);
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void handleDispose(DisposeEvent event) {
        this.getStructuredViewer().removeSelectionChangedListener(this.fForwardingSelectionListener);
        super.handleDispose(event);
    }

    protected abstract Control createControl(Composite var1);

    protected abstract StructuredViewer getStructuredViewer();

    private class ForwardingViewerSelectionListener
    implements ISelectionChangedListener {
        private ForwardingViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredMergeViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)StructuredMergeViewer.this, event.getSelection()));
        }
    }
}

