/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompareConfiguration;
import org.eclipse.emf.compare.conflict.DefaultConflictDetector;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.DefaultEquiEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.extension.IPostProcessor;
import org.eclipse.emf.compare.extension.PostProcessorRegistry;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.req.DefaultReqEngine;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;

public class EMFCompare {
    private final IMatchEngine matchEngine;
    private final IDiffEngine diffEngine;
    private final IReqEngine reqEngine;
    private final IEquiEngine equiEngine;
    private final IConflictDetector conflictDetector;
    private final PostProcessorRegistry postProcessorRegistry;

    protected EMFCompare(IMatchEngine matchEngine, IDiffEngine diffEngine, IReqEngine reqEngine, IEquiEngine equiEngine, IConflictDetector conflictDetector, PostProcessorRegistry postProcessorRegistry) {
        this.matchEngine = (IMatchEngine)Preconditions.checkNotNull((Object)matchEngine);
        this.diffEngine = (IDiffEngine)Preconditions.checkNotNull((Object)diffEngine);
        this.reqEngine = (IReqEngine)Preconditions.checkNotNull((Object)reqEngine);
        this.equiEngine = (IEquiEngine)Preconditions.checkNotNull((Object)equiEngine);
        this.conflictDetector = conflictDetector;
        this.postProcessorRegistry = (PostProcessorRegistry)Preconditions.checkNotNull((Object)postProcessorRegistry);
    }

    @Deprecated
    public static EMFCompareConfiguration createDefaultConfiguration() {
        BasicMonitor monitor = new BasicMonitor();
        return new EMFCompareConfiguration((Monitor)monitor, null);
    }

    public static IComparisonScope createDefaultScope(Notifier left, Notifier right) {
        return new DefaultComparisonScope(left, right, null);
    }

    public static IComparisonScope createDefaultScope(Notifier left, Notifier right, Notifier origin) {
        return new DefaultComparisonScope(left, right, origin);
    }

    public Comparison compare(IComparisonScope scope) {
        return this.compare(scope, (Monitor)new BasicMonitor());
    }

    public Comparison compare(IComparisonScope scope, Monitor monitor) {
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkNotNull((Object)monitor);
        Comparison comparison = this.matchEngine.match(scope, monitor);
        List<IPostProcessor> postProcessors = this.postProcessorRegistry.getPostProcessors(scope);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postMatch(comparison, monitor);
        }
        this.diffEngine.diff(comparison, monitor);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postDiff(comparison, monitor);
        }
        this.reqEngine.computeRequirements(comparison, monitor);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postRequirements(comparison, monitor);
        }
        this.equiEngine.computeEquivalences(comparison, monitor);
        for (IPostProcessor iPostProcessor : postProcessors) {
            iPostProcessor.postEquivalences(comparison, monitor);
        }
        if (comparison.isThreeWay() && this.conflictDetector != null) {
            this.conflictDetector.detect(comparison, monitor);
            for (IPostProcessor iPostProcessor : postProcessors) {
                iPostProcessor.postConflicts(comparison, monitor);
            }
        }
        return comparison;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected IMatchEngine matchEngine;
        protected IReqEngine reqEngine;
        protected IDiffEngine diffEngine;
        protected IEquiEngine equiEngine;
        protected IConflictDetector conflictDetector;
        protected PostProcessorRegistry registry;

        protected Builder() {
        }

        public Builder setMatchEngine(IMatchEngine me) {
            this.matchEngine = (IMatchEngine)Preconditions.checkNotNull((Object)me);
            return this;
        }

        public Builder setDiffEngine(IDiffEngine de) {
            this.diffEngine = (IDiffEngine)Preconditions.checkNotNull((Object)de);
            return this;
        }

        public Builder setRequirementEngine(IReqEngine re) {
            this.reqEngine = (IReqEngine)Preconditions.checkNotNull((Object)re);
            return this;
        }

        public Builder setEquivalenceEngine(IEquiEngine ee) {
            this.equiEngine = (IEquiEngine)Preconditions.checkNotNull((Object)ee);
            return this;
        }

        public Builder setConflictDetector(IConflictDetector cd) {
            this.conflictDetector = (IConflictDetector)Preconditions.checkNotNull((Object)cd);
            return this;
        }

        public Builder setPostProcessorRegistry(PostProcessorRegistry r) {
            this.registry = (PostProcessorRegistry)Preconditions.checkNotNull((Object)r);
            return this;
        }

        public EMFCompare build() {
            if (this.matchEngine == null) {
                this.matchEngine = DefaultMatchEngine.create(UseIdentifiers.WHEN_AVAILABLE);
            }
            if (this.diffEngine == null) {
                this.diffEngine = new DefaultDiffEngine(new DiffBuilder());
            }
            if (this.reqEngine == null) {
                this.reqEngine = new DefaultReqEngine();
            }
            if (this.equiEngine == null) {
                this.equiEngine = new DefaultEquiEngine();
            }
            if (this.registry == null) {
                this.registry = new PostProcessorRegistry();
            }
            if (this.conflictDetector == null) {
                this.conflictDetector = new DefaultConflictDetector();
            }
            return new EMFCompare(this.matchEngine, this.diffEngine, this.reqEngine, this.equiEngine, this.conflictDetector, this.registry);
        }
    }
}

