/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions;

import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.FilterAction;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FilterActionMenu
extends Action
implements IMenuCreator {
    private final StructureMergeViewerFilter structureMergeViewerFilter;
    private MenuManager menuManager;

    public FilterActionMenu(StructureMergeViewerFilter structureMergeViewerFilter, MenuManager menuManager) {
        super("", 4);
        this.menuManager = menuManager;
        this.structureMergeViewerFilter = structureMergeViewerFilter;
        this.setMenuCreator(this);
        this.setToolTipText("Filters");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.rcp.ui", (String)"icons/full/toolb16/filter.gif"));
    }

    public void createActions(IComparisonScope scope, Comparison comparison) {
        if (this.menuManager.isEmpty()) {
            IDifferenceFilter.Registry registry = EMFCompareRCPUIPlugin.getDefault().getFilterActionRegistry();
            for (IDifferenceFilter filterProvider : registry.getFilters(scope, comparison)) {
                FilterAction action = new FilterAction(filterProvider.getLabel(), this.structureMergeViewerFilter, filterProvider);
                if (filterProvider.defaultSelected()) {
                    action.setChecked(true);
                    action.run();
                }
                this.menuManager.add((IAction)action);
            }
        }
    }

    public void dispose() {
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        return this.menuManager.createContextMenu(parent);
    }

    public Menu getMenu(Menu parent) {
        return this.menuManager.getMenu();
    }
}

