/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.session.infinispan.InfinispanKeyBuilder;
import org.eclipse.jetty.session.infinispan.InfinispanSessionData;
import org.eclipse.jetty.session.infinispan.QueryManager;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedQueryManager
implements QueryManager {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedQueryManager.class);
    private Cache<String, InfinispanSessionData> _cache;

    public EmbeddedQueryManager(Cache<String, InfinispanSessionData> cache) {
        this._cache = cache;
    }

    public Set<String> queryExpiredSessions(SessionContext sessionContext, long time) {
        Objects.requireNonNull(sessionContext);
        QueryFactory qf = Search.getQueryFactory(this._cache);
        Query q = ((FilterConditionContext)qf.from(InfinispanSessionData.class).select(new String[]{"id"}).having("contextPath").eq((Object)sessionContext.getCanonicalContextPath())).and().having("expiry").lte((Object)time).and().having("expiry").gt((Object)0).build();
        List list = q.list();
        Set<String> ids = list.stream().map(a -> (String)a[0]).collect(Collectors.toSet());
        return ids;
    }

    public void deleteOrphanSessions(long time) {
        QueryFactory qf = Search.getQueryFactory(this._cache);
        Query q = qf.from(InfinispanSessionData.class).select(new String[]{"id", "contextPath", "vhost"}).having("expiry").lte((Object)time).and().having("expiry").gt((Object)0).build();
        List list = q.list();
        list.stream().forEach(a -> {
            String key = InfinispanKeyBuilder.build((String)((String)a[1]), (String)((String)a[2]), (String)((String)a[0]));
            try {
                this._cache.remove((Object)key);
            }
            catch (Exception e) {
                LOG.warn("Error deleting {}", (Object)key, (Object)e);
            }
        });
    }

    public boolean exists(SessionContext sessionContext, String id) {
        Objects.requireNonNull(sessionContext);
        QueryFactory qf = Search.getQueryFactory(this._cache);
        Query q = ((FilterConditionContext)((FilterConditionContext)qf.from(InfinispanSessionData.class).select(new String[]{"id"}).having("id").eq((Object)id)).and().having("contextPath").eq((Object)sessionContext.getCanonicalContextPath())).and().having("expiry").gt((Object)System.currentTimeMillis()).or().having("expiry").lte((Object)0).build();
        List list = q.list();
        return !list.isEmpty();
    }
}

