/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http3.internal.ControlStreamConnection;
import org.eclipse.jetty.http3.internal.DecoderStreamConnection;
import org.eclipse.jetty.http3.internal.EncoderStreamConnection;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.internal.parser.ControlParser;
import org.eclipse.jetty.http3.internal.parser.ParserListener;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.common.StreamType;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnidirectionalStreamConnection
extends AbstractConnection
implements Connection.UpgradeFrom {
    private static final Logger LOG = LoggerFactory.getLogger(UnidirectionalStreamConnection.class);
    private final ByteBufferPool byteBufferPool;
    private final QpackEncoder encoder;
    private final QpackDecoder decoder;
    private final ParserListener listener;
    private final VarLenInt parser = new VarLenInt();
    private boolean useInputDirectByteBuffers = true;
    private ByteBuffer buffer;

    public UnidirectionalStreamConnection(QuicStreamEndPoint endPoint, Executor executor, ByteBufferPool byteBufferPool, QpackEncoder encoder, QpackDecoder decoder, ParserListener listener) {
        super((EndPoint)endPoint, executor);
        this.byteBufferPool = byteBufferPool;
        this.encoder = encoder;
        this.decoder = decoder;
        this.listener = listener;
    }

    public QuicStreamEndPoint getEndPoint() {
        return (QuicStreamEndPoint)super.getEndPoint();
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public ByteBuffer onUpgradeFrom() {
        int remaining = this.buffer.remaining();
        ByteBuffer copy = this.buffer.isDirect() ? ByteBuffer.allocateDirect(remaining) : ByteBuffer.allocate(remaining);
        copy.put(this.buffer);
        this.byteBufferPool.release(this.buffer);
        this.buffer = null;
        copy.flip();
        return copy;
    }

    public void onFillable() {
        block9: {
            try {
                int filled;
                block8: {
                    if (this.buffer == null) {
                        this.buffer = this.byteBufferPool.acquire(2048, this.isUseInputDirectByteBuffers());
                    }
                    do {
                        filled = this.getEndPoint().fill(this.buffer);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("filled {} on {}: {}", new Object[]{filled, this, BufferUtil.toDetailString((ByteBuffer)this.buffer)});
                        }
                        if (filled <= 0) break block8;
                    } while (!this.parser.decode(this.buffer, this::detectAndUpgrade));
                    break block9;
                }
                if (filled == 0) {
                    this.byteBufferPool.release(this.buffer);
                    this.fillInterested();
                } else {
                    this.byteBufferPool.release(this.buffer);
                    this.buffer = null;
                    this.getEndPoint().close();
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("could not process stream {}", (Object)this.getEndPoint(), (Object)x);
                }
                this.byteBufferPool.release(this.buffer);
                this.buffer = null;
                this.getEndPoint().close(x);
            }
        }
    }

    private void detectAndUpgrade(long streamType) {
        if (streamType == 0L) {
            ControlParser parser = new ControlParser(this.listener);
            ControlStreamConnection newConnection = new ControlStreamConnection((EndPoint)this.getEndPoint(), this.getExecutor(), this.byteBufferPool, parser);
            newConnection.setInputBufferSize(this.getInputBufferSize());
            newConnection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrading to {}", (Object)newConnection);
            }
            this.getEndPoint().upgrade((Connection)newConnection);
        } else if (streamType == 2L) {
            EncoderStreamConnection newConnection = new EncoderStreamConnection((EndPoint)this.getEndPoint(), this.getExecutor(), this.byteBufferPool, this.decoder);
            newConnection.setInputBufferSize(this.getInputBufferSize());
            newConnection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrading to {}", (Object)newConnection);
            }
            this.getEndPoint().upgrade((Connection)newConnection);
        } else if (streamType == 3L) {
            DecoderStreamConnection newConnection = new DecoderStreamConnection((EndPoint)this.getEndPoint(), this.getExecutor(), this.byteBufferPool, this.encoder);
            newConnection.setInputBufferSize(this.getInputBufferSize());
            newConnection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrading to {}", (Object)newConnection);
            }
            this.getEndPoint().upgrade((Connection)newConnection);
        } else if (StreamType.isReserved((long)streamType)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("reserved stream type {}, closing {}", (Object)Long.toHexString(streamType), (Object)this);
            }
            this.getEndPoint().close(HTTP3ErrorCode.randomReservedCode(), null);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unsupported stream type {}, closing {}", (Object)Long.toHexString(streamType), (Object)this);
            }
            this.getEndPoint().close(HTTP3ErrorCode.STREAM_CREATION_ERROR.code(), null);
        }
    }
}

