/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.ui.wizards.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.amalgam.discovery.InstallableComponent;
import org.eclipse.amalgam.discovery.ui.viewer.DiscoveryContentProvider;
import org.eclipse.amalgam.discovery.ui.viewer.DiscoveryViewer;
import org.eclipse.amalgam.discovery.ui.wizards.DiscoveryWizard;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class DiscoveryWizardMainPage
extends WizardPage
implements IShellProvider {
    private static final int MINIMUM_HEIGHT = 480;
    private DiscoveryViewer viewer;
    private DiscoveryContentProvider provider;

    public DiscoveryWizardMainPage(DiscoveryContentProvider provider) {
        super(DiscoveryWizardMainPage.class.getSimpleName());
        this.provider = provider;
        this.setTitle(provider.getTitle());
        this.setDescription(provider.getDescription());
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.viewer = new DiscoveryViewer(this, (IRunnableContext)this.getContainer(), this.provider);
        this.viewer.setShowConnectorDescriptorKindFilter(this.getWizard().isShowConnectorDescriptorKindFilter());
        this.viewer.setShowConnectorDescriptorTextFilter(this.getWizard().isShowConnectorDescriptorTextFilter());
        this.viewer.setVerifyUpdateSiteAvailability(true);
        this.viewer.setMinimumHeight(480);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiscoveryWizardMainPage.this.setPageComplete(!DiscoveryWizardMainPage.this.viewer.getInstallableConnectors().isEmpty());
            }
        });
        this.viewer.createControl(parent);
        this.setControl(this.viewer.getControl());
    }

    public DiscoveryWizard getWizard() {
        return (DiscoveryWizard)super.getWizard();
    }

    public List<InstallableComponent> getInstallableConnectors() {
        return this.viewer.getInstallableConnectors();
    }

    private void maybeUpdateDiscovery() {
        if (!this.getControl().isDisposed() && this.isCurrentPage()) {
            this.viewer.updateDiscovery();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiscoveryWizardMainPage.this.maybeUpdateDiscovery();
                }
            });
        }
    }

    public void setModelingComponents(Collection<InstallableComponent> components) {
    }
}

