/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNode;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNodeAccess;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTStackTraceElement;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtStackTraceBuilder {
    private static final String NAME_SEPARATOR = "::";
    private static final String UNKNOWN_NAME = "<Unknown>";
    private static final int UNKNOWN_LINE_NUM = -1;
    private QvtOperationalEvaluationEnv fEvalEnv;

    public QvtStackTraceBuilder(QvtOperationalEvaluationEnv evalEnv) {
        if (evalEnv == null) {
            throw new IllegalArgumentException();
        }
        this.fEvalEnv = evalEnv;
    }

    public List<QVTStackTraceElement> buildStackTrace() {
        LinkedList<QVTStackTraceElement> elements = new LinkedList<QVTStackTraceElement>();
        QvtOperationalEvaluationEnv nextEnv = this.fEvalEnv;
        while (nextEnv != null) {
            InternalEvaluationEnv internalEnv;
            QvtOperationalEvaluationEnv parent = nextEnv.getParent();
            if (parent != null && (internalEnv = nextEnv.getAdapter(InternalEvaluationEnv.class)).getCurrentModule() != null) {
                elements.addLast(this.createStackElement(nextEnv));
            }
            nextEnv = nextEnv.getParent();
        }
        QvtOperationalEvaluationEnv rootEnv = this.fEvalEnv.getRoot();
        QvtOperationalEvaluationEnv aggregatingEnv = EvaluationUtil.getAggregatingContext(rootEnv);
        if (aggregatingEnv != null) {
            List<QVTStackTraceElement> aggregatedStackTrace = new QvtStackTraceBuilder(aggregatingEnv).buildStackTrace();
            ArrayList<QVTStackTraceElement> result = new ArrayList<QVTStackTraceElement>(elements.size() + aggregatedStackTrace.size());
            result.addAll(elements);
            result.addAll(aggregatedStackTrace);
            return result;
        }
        return Collections.unmodifiableList(elements);
    }

    private QVTStackTraceElement createStackElement(QvtOperationalEvaluationEnv env) {
        IModuleSourceInfo sourceInfo;
        String unitName = null;
        String moduleName = UNKNOWN_NAME;
        String operName = UNKNOWN_NAME;
        int lineNumber = -1;
        Module module = null;
        ImperativeOperation operation = env.getOperation();
        InternalEvaluationEnv internEvalEnv = env.getAdapter(InternalEvaluationEnv.class);
        int resultOffset = QvtStackTraceBuilder.getCurrentASTOffset(internEvalEnv);
        ModuleInstance thisInstance = internEvalEnv.getCurrentModule();
        if (thisInstance == null) {
            throw new IllegalArgumentException("Currently executed model is not set in environment");
        }
        module = thisInstance.getModule();
        assert (module != null);
        moduleName = module.getName();
        if (operation == null) {
            ASTSyntheticNode astNode;
            operName = moduleName;
            if ((internEvalEnv.getCurrentIP() == module || resultOffset < -1) && (astNode = ASTSyntheticNodeAccess.getASTNode((EObject)module)) != null) {
                resultOffset = astNode.getStartPosition();
            }
        } else {
            operName = operation.getName();
            EClassifier contextType = QvtOperationalParserUtil.getContextualType(operation);
            if (contextType != null) {
                operName = String.valueOf(contextType.getName()) + NAME_SEPARATOR + operName;
            }
        }
        if ((sourceInfo = ASTBindingHelper.getModuleSourceBinding(module)) != null) {
            URI uri = sourceInfo.getSourceURI();
            unitName = uri.lastSegment();
            if (resultOffset >= 0) {
                lineNumber = sourceInfo.getLineNumberProvider().getLineNumber(resultOffset);
            }
        }
        return new QVTStackTraceElement(moduleName, operName, unitName, lineNumber);
    }

    private static int getCurrentASTOffset(InternalEvaluationEnv evalEnv) {
        EObject currentIPObject = evalEnv.getCurrentIP();
        if (currentIPObject instanceof ASTNode) {
            ASTNode astNode = (ASTNode)currentIPObject;
            return astNode.getStartPosition();
        }
        ASTSyntheticNode astNode = ASTSyntheticNodeAccess.getASTNode(currentIPObject);
        if (astNode != null) {
            return astNode.getStartPosition();
        }
        return -1;
    }
}

