/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.m2m.internal.qvt.oml.compiler.ParsedModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.LibraryImportCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModelTypeCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.RenameCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.OutlineNode;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.QvtOutlineLabelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.ocl.OclQvtoPlugin;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperation;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;

public class QvtOutlineInput {
    private ParsedModuleCS myModule;
    private Object[] myChildren;
    private ModuleNode myModuleNode;

    public QvtOutlineInput() {
        this(null);
    }

    public QvtOutlineInput(ParsedModuleCS parsedModuleCS) {
        this.myModule = parsedModuleCS;
    }

    public void mappingModuleUpdated(ParsedModuleCS parsedModuleCS) {
        this.myModule = parsedModuleCS;
        this.myModuleNode.setIdentity(this.getModuleNodeIdentity());
    }

    public Object[] getChildren() {
        if (this.myChildren == null) {
            this.myModuleNode = new ModuleNode(this.getModuleNodeIdentity());
            this.myChildren = new Object[]{new ImportsNode(), new MetamodelsNode(), new RenamesNode(), new PropertiesNode(), this.myModuleNode};
        }
        return this.myChildren;
    }

    private String getModuleNodeIdentity() {
        return this.myModule != null ? QvtOutlineLabelProvider.getMappingModuleLabel(this.myModule.getModuleCS()) : "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImportedModuleNode
    extends OutlineNode {
        private final MappingModuleCS myImportedModule;

        public ImportedModuleNode(String identity, MappingModuleCS importedModule, OutlineNode parent, int type, CSTNode syntaxElement) {
            super(identity, parent, type, syntaxElement);
            this.myImportedModule = importedModule;
        }

        @Override
        public List<OutlineNode> getChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            if (this.myImportedModule != null) {
                for (MappingMethodCS operationCS : this.myImportedModule.getMethods()) {
                    MappingDeclarationCS declaration = operationCS.getMappingDeclarationCS();
                    if (declaration == null) continue;
                    String label = QvtOutlineLabelProvider.getMappingRuleLabel(operationCS);
                    OutlineNode childNode = new OutlineNode(label, this, 8);
                    result.add(childNode);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ImportsNode
    extends ModuleDependentNode {
        public ImportsNode() {
            super("imports", QvtOutlineInput.this, 1);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            for (ImportCS imp : QvtOutlineInput.this.myModule.getModuleCS().getImports()) {
                PathNameCS importPath = imp.getPathNameCS();
                if (imp instanceof LibraryImportCS) {
                    LibraryNode childNode = new LibraryNode(QvtOutlineLabelProvider.getImportLabel(importPath), this, 0, (CSTNode)importPath);
                    result.add(childNode);
                    continue;
                }
                if (QvtOutlineInput.this.myModule.getParsedImport(importPath) == null) continue;
                MappingModuleCS moduleCS = QvtOutlineInput.this.myModule.getParsedImport(importPath).getModuleCS();
                ImportedModuleNode childNode = new ImportedModuleNode(QvtOutlineLabelProvider.getImportLabel(importPath), moduleCS, this, 0, (CSTNode)importPath);
                result.add(childNode);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LibraryNode
    extends OutlineNode {
        public LibraryNode(String identity, OutlineNode parent, int type, CSTNode syntaxElement) {
            super(identity, parent, type, syntaxElement);
        }

        @Override
        public List<OutlineNode> getChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            String libId = this.getIdentity();
            Library lib = OclQvtoPlugin.getDefault().getLibrariesRegistry().getLibrary(libId);
            if (lib != null) {
                try {
                    for (LibraryOperation libOp : lib.getLibraryOperations()) {
                        String label = QvtOutlineLabelProvider.getMappingDeclarationAsString(libOp.getName(), "", Collections.<String>emptyList());
                        OutlineNode childNode = new OutlineNode(label, this, 8);
                        result.add(childNode);
                    }
                }
                catch (LibraryCreationException e) {
                    Logger.getLogger().log(Logger.SEVERE, "Exception while loading library", e);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MetamodelsNode
    extends ModuleDependentNode {
        public MetamodelsNode() {
            super("metamodels", QvtOutlineInput.this, 3);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            for (ModelTypeCS modelTypeCS : QvtOutlineInput.this.myModule.getModuleCS().getMetamodels()) {
                if (modelTypeCS == null || modelTypeCS.getPackageRefs().isEmpty()) continue;
                OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getMetamodelLabel(modelTypeCS), this, 2, (CSTNode)modelTypeCS);
                result.add(childNode);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ModuleDependentNode
    extends OutlineNode {
        protected ModuleDependentNode(String identity, Object parent, int type) {
            super(identity, parent, type);
        }

        protected ModuleDependentNode(String identity, Object parent, int type, CSTNode syntaxElement) {
            super(identity, parent, type, syntaxElement);
        }

        @Override
        public final List<OutlineNode> getChildren() {
            if (QvtOutlineInput.this.myModule == null) {
                return Collections.emptyList();
            }
            return this.doGetChildren();
        }

        protected abstract List<OutlineNode> doGetChildren();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ModuleNode
    extends ModuleDependentNode {
        public ModuleNode(String identity) {
            super(identity, QvtOutlineInput.this, 0);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            for (MappingMethodCS method : QvtOutlineInput.this.myModule.getModuleCS().getMethods()) {
                OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getMappingRuleLabel(method), this, 8, (CSTNode)method);
                result.add(childNode);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PropertiesNode
    extends ModuleDependentNode {
        public PropertiesNode() {
            super("properties", QvtOutlineInput.this, 7);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            for (ModulePropertyCS prop : QvtOutlineInput.this.myModule.getModuleCS().getProperties()) {
                OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getPropertyLabel(prop), this, 6, (CSTNode)prop);
                result.add(childNode);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RenamesNode
    extends ModuleDependentNode {
        public RenamesNode() {
            super("renamings", QvtOutlineInput.this, 5);
        }

        @Override
        protected List<OutlineNode> doGetChildren() {
            ArrayList<OutlineNode> result = new ArrayList<OutlineNode>();
            for (RenameCS rename : QvtOutlineInput.this.myModule.getModuleCS().getRenamings()) {
                OutlineNode childNode = new OutlineNode(QvtOutlineLabelProvider.getRenameLabel(rename), this, 4, (CSTNode)rename);
                result.add(childNode);
            }
            return result;
        }
    }
}

