/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompositeUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.DelegatingUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedImportResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceUnitResolver
extends DelegatingUnitResolver
implements UnitProvider {
    private List<IContainer> fRoots;

    public static WorkspaceUnitResolver getResolver(IProject project) throws CoreException {
        IContainer sourceContainer = QVTOBuilderConfig.getConfig(project).getSourceContainer();
        if (sourceContainer != null) {
            return new WorkspaceUnitResolver(Collections.singletonList(sourceContainer));
        }
        return null;
    }

    public void addSourceContainer(IContainer container) {
        if (container == null) {
            throw new IllegalArgumentException();
        }
        this.fRoots.add(container);
    }

    public static UnitProxy getUnit(IFile unitFile) {
        if (unitFile.exists()) {
            try {
                WorkspaceUnitResolver resolver = WorkspaceUnitResolver.getResolver(unitFile.getProject());
                if (resolver != null) {
                    for (IContainer nextContainer : resolver.fRoots) {
                        IPath unitPath;
                        IPath srcContainerPath = nextContainer.getFullPath();
                        if (!srcContainerPath.isPrefixOf(unitPath = unitFile.getFullPath())) continue;
                        return resolver.createFileUnit(srcContainerPath, unitPath);
                    }
                }
            }
            catch (CoreException e) {
                QVTOProjectPlugin.log(e.getStatus());
            }
        }
        return null;
    }

    public WorkspaceUnitResolver(List<IContainer> sourceContainers) {
        if (sourceContainers == null || sourceContainers.contains(null)) {
            throw new IllegalArgumentException("null source container");
        }
        IProject project = null;
        for (IContainer container : sourceContainers) {
            if (project != null) {
                if (project != container.getProject()) {
                    throw new IllegalArgumentException("source containers must be from single project");
                }
            } else {
                project = container.getProject();
            }
            if (container.exists()) continue;
            throw new IllegalArgumentException("Unexisting source container");
        }
        this.fRoots = new ArrayList<IContainer>(sourceContainers);
        if (project != null) {
            this.setParent((UnitResolver)new CompositeUnitResolver(new UnitResolver[]{new BlackboxUnitResolver(URIUtils.getResourceURI((IResource)project)), DeployedImportResolver.INSTANCE}));
        }
    }

    protected UnitProxy doResolveUnit(String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("null qualified name");
        }
        IResource member = null;
        for (IContainer nextContainer : this.fRoots) {
            member = this.resolveResource(nextContainer, qualifiedName, true);
            if (member == null) continue;
            return this.createFileUnit(nextContainer.getFullPath(), member.getFullPath());
        }
        return null;
    }

    public void accept(UnitProvider.UnitVisitor visitor, String scopeQualifiedName, int depth, boolean includeExternal) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        Iterator<IContainer> iterator = this.fRoots.iterator();
        while (iterator.hasNext()) {
            IContainer nextContainer;
            IContainer resourceToVisit = nextContainer = iterator.next();
            if (scopeQualifiedName != null && (resourceToVisit = this.resolveResource(nextContainer, scopeQualifiedName, false)) == null) continue;
            try {
                ResourceVisitor resourceVisitor = new ResourceVisitor(visitor, nextContainer, resourceToVisit.getFullPath(), depth);
                resourceToVisit.accept((IResourceProxyVisitor)resourceVisitor, 0);
            }
            catch (CoreException coreException) {}
        }
    }

    private IResource resolveResource(IContainer container, String qualifiedName, boolean isUnit) {
        IPath unitPath = WorkspaceUnitResolver.qName2Path(qualifiedName);
        if (isUnit) {
            unitPath = unitPath.addFileExtension("qvto");
        }
        return container.findMember(unitPath);
    }

    private FileUnit createFileUnit(IPath sourceContainer, IPath unitPath) {
        String unitName = unitPath.removeFileExtension().lastSegment();
        String namespace = ResolverUtils.getNamespace((IPath)unitPath.removeLastSegments(1), (IPath)sourceContainer);
        URI uri = URI.createPlatformResourceURI((String)unitPath.toString(), (boolean)true);
        return new FileUnit(namespace, unitName, uri);
    }

    private static IPath qName2Path(String qname) {
        assert (qname != null);
        String pathStr = qname.replace('.', '/');
        return new Path(pathStr);
    }

    public static List<UnitProxy> findAllUnits(IProject project) {
        try {
            WorkspaceUnitResolver resolver = WorkspaceUnitResolver.getResolver(project);
            if (resolver != null) {
                return ResolverUtils.findAllUnits((UnitProvider)resolver);
            }
        }
        catch (CoreException e) {
            QVTOProjectPlugin.log(e.getStatus());
        }
        return Collections.emptyList();
    }

    private class FileUnit
    extends UnitProxy {
        public FileUnit(String namespace, String unitName, URI uri) {
            super(namespace, unitName, uri);
            assert (uri.isPlatformResource());
        }

        public int getContentType() {
            return 0;
        }

        public UnitResolver getResolver() {
            return WorkspaceUnitResolver.this;
        }

        public UnitContents getContents() throws IOException {
            URI uri = this.getURI();
            String wsRelativePath = uri.toPlatformString(true);
            final IFile sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(wsRelativePath));
            if (!sourceFile.exists()) {
                throw new IOException("File does not exist, URI: " + sourceFile.getFullPath());
            }
            return new UnitContents.CSTContents(){

                public Reader getContents() throws IOException {
                    try {
                        return new InputStreamReader(sourceFile.getContents(), sourceFile.getCharset());
                    }
                    catch (CoreException e) {
                        throw new IOException(e.getLocalizedMessage());
                    }
                }
            };
        }
    }

    private class ResourceVisitor
    implements IResourceProxyVisitor {
        private UnitProvider.UnitVisitor fUnitVisitor;
        private IContainer fContainer;
        private IPath fScope;
        private int fDepth;

        ResourceVisitor(UnitProvider.UnitVisitor unitVisitor, IContainer srcContainer, IPath scope, int depth) {
            assert (unitVisitor != null);
            assert (srcContainer != null);
            assert (scope != null);
            this.fUnitVisitor = unitVisitor;
            this.fContainer = srcContainer;
            this.fScope = scope;
            this.fDepth = depth;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String name = proxy.getName();
            int type = proxy.getType();
            if (type == 1 && name.endsWith(".qvto")) {
                IPath path = proxy.requestFullPath();
                String unitName = path.removeFileExtension().lastSegment();
                String namespace = ResolverUtils.getNamespace((IPath)path.removeLastSegments(1), (IPath)this.fContainer.getFullPath());
                URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
                FileUnit unit = new FileUnit(namespace, unitName, uri);
                return this.fUnitVisitor.visitUnit((UnitProxy)unit);
            }
            if (type == 2 || type == 4) {
                IPath visitedPath;
                if (this.fDepth == 0) {
                    return false;
                }
                return this.fDepth != 1 || this.fScope.equals((Object)(visitedPath = proxy.requestFullPath()));
            }
            return false;
        }
    }
}

