/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.wizard.atlplugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableData;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.common.RegisteredPackageDialog;
import org.eclipse.m2m.atl.adt.ui.common.WorkspaceFileDialog;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AtlPluginScreen
extends WizardPage {
    private static final String METAMETAMODEL_ID = "#EMF";
    private IFile defaultAtlFile;
    private CreateRunnableData runnableData;
    private Composite container;
    private Composite paramsComposite;
    private Button initFromFile;
    private Button initFromConfig;
    private Text fileText;
    private Combo configChoice;

    public AtlPluginScreen(IFile atlFile) {
        super(Messages.getString("AtlPluginScreen.Page.Name"));
        this.setTitle(Messages.getString("AtlPluginScreen.Title"));
        this.setDescription(Messages.getString("AtlPluginScreen.Page.Description"));
        this.setImageDescriptor(AtlUIPlugin.getImageDescriptor("ATLWizard.png"));
        this.defaultAtlFile = atlFile;
        this.setPageComplete(false);
        this.runnableData = new CreateRunnableData();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.initializeDialogUnits((Control)this.container);
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.container.setLayoutData((Object)new GridData(768));
        this.initFromFile = new Button(this.container, 16);
        this.initFromFile.setLayoutData((Object)new GridData(1));
        this.initFromFile.setText(Messages.getString("AtlPluginScreen.INIT_FROM_FILE"));
        this.fileText = new Text(this.container, 2048);
        this.fileText.setLayoutData((Object)new GridData(768));
        final Button fileButton = this.createButton(this.container, Messages.getString("AtlPluginScreen.WORKSPACE"));
        this.initFromConfig = new Button(this.container, 16);
        this.initFromConfig.setText(Messages.getString("AtlPluginScreen.INIT_FROM_CONFIG"));
        this.configChoice = new Combo(this.container, 0);
        this.configChoice.setLayoutData((Object)new GridData(768));
        int i = 0;
        while (i < AtlPluginScreen.getConfigurations().length) {
            ILaunchConfiguration config = AtlPluginScreen.getConfigurations()[i];
            this.configChoice.add(config.getName());
            ++i;
        }
        this.paramsComposite = new Composite(this.container, 0);
        this.paramsComposite.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        this.paramsComposite.setLayoutData((Object)data);
        this.initFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = AtlPluginScreen.this.initFromFile.getSelection();
                AtlPluginScreen.this.fileText.setEnabled(enabled);
                fileButton.setEnabled(enabled);
                if (enabled) {
                    try {
                        AtlPluginScreen.this.runnableData.load(new String[]{AtlPluginScreen.this.fileText.getText().trim()});
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                    catch (CoreException e1) {
                        throw new RuntimeException(e1);
                    }
                    AtlPluginScreen.this.updateFromParameters();
                }
                AtlPluginScreen.this.checkValid();
                super.widgetSelected(e);
            }
        });
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    AtlPluginScreen.this.runnableData.load(new String[]{AtlPluginScreen.this.fileText.getText().trim()});
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                catch (CoreException e1) {
                    throw new RuntimeException(e1);
                }
                AtlPluginScreen.this.updateFromParameters();
                AtlPluginScreen.this.checkValid();
            }
        });
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceFileDialog dialog = new WorkspaceFileDialog(AtlPluginScreen.this.getShell(), "atl");
                dialog.open();
                Object result = dialog.getFirstResult();
                if (result != null && result instanceof IFile) {
                    IFile currentFile = (IFile)result;
                    AtlPluginScreen.this.fileText.setText(currentFile.getFullPath().toString());
                }
                super.widgetSelected(e);
            }
        });
        this.initFromConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = AtlPluginScreen.this.initFromConfig.getSelection();
                AtlPluginScreen.this.configChoice.setEnabled(enabled);
                if (enabled) {
                    try {
                        ILaunchConfiguration configuration = AtlPluginScreen.getConfiguration(AtlPluginScreen.this.configChoice.getText());
                        if (configuration != null) {
                            AtlPluginScreen.this.runnableData.load(configuration);
                        }
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(e1);
                    }
                    catch (CoreException e1) {
                        throw new RuntimeException(e1);
                    }
                    AtlPluginScreen.this.updateFromParameters();
                }
                AtlPluginScreen.this.checkValid();
                super.widgetSelected(e);
            }
        });
        this.configChoice.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ILaunchConfiguration configuration = AtlPluginScreen.getConfiguration(AtlPluginScreen.this.configChoice.getText());
                    if (configuration != null) {
                        AtlPluginScreen.this.runnableData.load(configuration);
                    }
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                catch (CoreException e1) {
                    throw new RuntimeException(e1);
                }
                AtlPluginScreen.this.updateFromParameters();
                AtlPluginScreen.this.checkValid();
            }
        });
        if (this.defaultAtlFile == null) {
            this.initFromConfig.setSelection(true);
        } else {
            this.fileText.setText(this.defaultAtlFile.getFullPath().toString());
            this.initFromFile.setSelection(true);
        }
        this.fileText.setEnabled(this.initFromFile.getSelection());
        fileButton.setEnabled(this.initFromFile.getSelection());
        this.configChoice.setEnabled(this.initFromConfig.getSelection());
        this.checkValid();
        this.container.layout();
        this.setControl((Control)this.container);
    }

    public CreateRunnableData getRunnableData() {
        return this.runnableData;
    }

    private void updateFromParameters() {
        Control[] controlArray = this.paramsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        for (String metamodelName : this.runnableData.getAllMetamodelsNames()) {
            String metamodelLocation = null;
            if (this.runnableData.getMetamodelLocations().containsKey(metamodelName)) {
                metamodelLocation = (String)this.runnableData.getMetamodelLocations().get(metamodelName);
            }
            this.createMetamodelControl(this.paramsComposite, metamodelName, metamodelLocation);
        }
        for (String libraryName : this.runnableData.getAllLibrariesNames()) {
            this.createLibraryControl(this.paramsComposite, libraryName, (String)this.runnableData.getLibraryLocations().get(libraryName));
        }
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        int height = shell.computeSize((int)-1, (int)-1, (boolean)true).y;
        shell.setSize(shellSize.x, height);
        this.paramsComposite.layout();
        this.container.layout();
    }

    private Group createMetamodelControl(Composite parent, final String metamodelName, String metamodelLocation) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("AtlPluginScreen.METAMODEL", metamodelName));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(4, false));
        final Label locationLabel = new Label((Composite)group, 0);
        locationLabel.setText(Messages.getString("AtlPluginScreen.LOCATION"));
        final Text locationText = new Text((Composite)group, 2048);
        locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        if (metamodelLocation != null) {
            locationText.setText(metamodelLocation);
        }
        final Button browseEMFRegistry = new Button((Composite)group, 0);
        browseEMFRegistry.setText(Messages.getString("AtlPluginScreen.BROWSE"));
        final Button isMMMButton = new Button((Composite)group, 32);
        isMMMButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        isMMMButton.setText(Messages.getString("AtlPluginScreen.IS_METAMETA"));
        locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlPluginScreen.this.runnableData.updateMetamodelLocation(metamodelName, locationText.getText());
                AtlPluginScreen.this.checkValid();
            }
        });
        browseEMFRegistry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RegisteredPackageDialog dialog = new RegisteredPackageDialog(AtlPluginScreen.this.getShell());
                dialog.setRuntimeOnly(true);
                if (dialog.open() == 0) {
                    locationText.setText(dialog.getResultAsString());
                }
            }
        });
        isMMMButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isMetametamodel = isMMMButton.getSelection();
                browseEMFRegistry.setEnabled(!isMetametamodel);
                locationLabel.setEnabled(!isMetametamodel);
                locationText.setEnabled(!isMetametamodel);
                if (isMetametamodel) {
                    AtlPluginScreen.this.runnableData.updateMetamodelLocation(metamodelName, AtlPluginScreen.METAMETAMODEL_ID);
                } else {
                    AtlPluginScreen.this.runnableData.updateMetamodelLocation(metamodelName, locationText.getText());
                }
                AtlPluginScreen.this.checkValid();
                super.widgetSelected(e);
            }
        });
        if (metamodelLocation != null && metamodelLocation.equals(METAMETAMODEL_ID)) {
            isMMMButton.setSelection(true);
            browseEMFRegistry.setEnabled(false);
            locationLabel.setEnabled(false);
            locationText.setEnabled(false);
            this.runnableData.updateMetamodelLocation(metamodelName, METAMETAMODEL_ID);
        }
        return group;
    }

    private Group createLibraryControl(Composite parent, final String libraryName, String libraryLocation) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("AtlPluginScreen.LIBRARY", libraryName));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(3, false));
        Label locationLabel = new Label((Composite)group, 0);
        locationLabel.setText(Messages.getString("AtlPluginScreen.LOCATION"));
        final Text locationText = new Text((Composite)group, 2048);
        locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (libraryLocation != null) {
            locationText.setText(libraryLocation);
        }
        Button browseWorkspace = new Button((Composite)group, 0);
        browseWorkspace.setText(Messages.getString("AtlPluginScreen.BROWSE"));
        locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlPluginScreen.this.runnableData.updateLibraryLocation(libraryName, locationText.getText());
                AtlPluginScreen.this.checkValid();
            }
        });
        browseWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WorkspaceFileDialog dialog = new WorkspaceFileDialog(AtlPluginScreen.this.getShell(), "asm");
                dialog.open();
                Object result = dialog.getFirstResult();
                if (result != null && result instanceof IFile) {
                    IFile currentFile = (IFile)result;
                    locationText.setText(currentFile.getFullPath().toString());
                }
            }
        });
        return group;
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setAlignment(0x1000000);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)data);
        return button;
    }

    private static ILaunchConfiguration[] getConfigurations() {
        ArrayList<ILaunchConfiguration> res = new ArrayList<ILaunchConfiguration>();
        if (CoreService.isEclipseRunning()) {
            try {
                ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                int i = 0;
                while (i < configs.length) {
                    ILaunchConfiguration config = configs[i];
                    if (config.getType().getIdentifier().equals("org.eclipse.m2m.atl.adt.launching.atlTransformation")) {
                        res.add(config);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return res.toArray(new ILaunchConfiguration[res.size()]);
    }

    private static ILaunchConfiguration getConfiguration(String name) throws CoreException {
        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int i = 0;
        while (i < configs.length) {
            ILaunchConfiguration config = configs[i];
            if (config.getName().equals(name)) {
                return config;
            }
            ++i;
        }
        return null;
    }

    private void checkValid() {
        String errorMessage = null;
        String message = null;
        if (this.initFromFile.getSelection() && (this.fileText.getText() == null || "".equals(this.fileText.getText().trim()))) {
            message = Messages.getString("AtlPluginScreen.UNSET_FILE");
        } else if (this.initFromConfig.getSelection() && (this.configChoice.getText() == null || "".equals(this.configChoice.getText().trim()))) {
            message = Messages.getString("AtlPluginScreen.UNSET_CONFIG");
        } else if (this.runnableData.getTransformationFiles() == null || this.runnableData.getTransformationFiles().length == 0) {
            errorMessage = !this.initFromConfig.getSelection() ? String.valueOf(Messages.getString("AtlPluginScreen.INVALID_FILE")) + this.fileText.getText() : Messages.getString("AtlPluginScreen.INVALID_CONFIGURATION");
        } else {
            IFile[] iFileArray = this.runnableData.getTransformationFiles();
            int n = iFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (!file.isAccessible()) {
                    errorMessage = String.valueOf(Messages.getString("AtlPluginScreen.INVALID_FILE")) + file.getFullPath();
                }
                ++n2;
            }
            if (errorMessage == null) {
                if (!"Module".equals(this.runnableData.getFileType()) && !"Query".equals(this.runnableData.getFileType())) {
                    errorMessage = Messages.getString("AtlPluginScreen.CANNOT_LAUNCH");
                } else {
                    String location;
                    ArrayList<String> missingLocations = new ArrayList<String>();
                    for (String name : this.runnableData.getAllMetamodelsNames()) {
                        location = (String)this.runnableData.getMetamodelLocations().get(name);
                        if (location != null && !"".equals(location.trim())) continue;
                        missingLocations.add(name);
                    }
                    for (String name : this.runnableData.getAllLibrariesNames()) {
                        location = (String)this.runnableData.getLibraryLocations().get(name);
                        if (location == null || "".equals(location.trim())) {
                            missingLocations.add(name);
                            continue;
                        }
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(location));
                        if (resource != null && resource.isAccessible()) continue;
                        errorMessage = String.valueOf(Messages.getString("AtlPluginScreen.UNABLE_TO_ACCESS_LIB")) + location;
                    }
                    if (errorMessage == null && !missingLocations.isEmpty()) {
                        message = Messages.getString("AtlPluginScreen.INVALID_LOCATION");
                        Iterator iterator = missingLocations.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            message = String.valueOf(message) + string;
                            if (!iterator.hasNext()) continue;
                            message = String.valueOf(message) + ", ";
                        }
                    }
                }
            }
        }
        this.setErrorMessage(errorMessage);
        this.setMessage(message, 1);
        this.setPageComplete(message == null && errorMessage == null);
    }
}

