/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.startup;

import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.atl.common.ATLLogger;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private IResource findAsmFile(IResource res) {
        String atlFileName = res.getName();
        String asmFileName = String.valueOf(atlFileName.substring(0, atlFileName.lastIndexOf(46))) + ".asm";
        IFile asm = res.getParent().getFile((IPath)new Path(asmFileName));
        if (asm.exists()) {
            return asm;
        }
        return null;
    }

    private void delAsmFile(final IResource res) {
        Thread op = new Thread(){

            public void run() {
                IResource asm = ResourceDeltaVisitor.this.findAsmFile(res);
                if (asm != null) {
                    try {
                        asm.delete(true, null);
                    }
                    catch (CoreException e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        };
        op.start();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource res = delta.getResource();
        switch (delta.getKind()) {
            case 2: {
                if (!"atl".equals(res.getFileExtension())) break;
                this.delAsmFile(res);
                break;
            }
        }
        return true;
    }
}

