/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMFrameExecutionContext;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitLocationExecutionContext
implements VMFrameExecutionContext {
    private final Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> fEnv;
    private final QvtOperationalEvaluationEnv fEvalEnv;

    UnitLocationExecutionContext(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env, QvtOperationalEvaluationEnv evalEnv) {
        if (env == null || evalEnv == null) {
            throw new IllegalArgumentException();
        }
        this.fEnv = env;
        this.fEvalEnv = evalEnv;
    }

    @Override
    public EClassifier getOCLType(EStructuralFeature feature) {
        return (EClassifier)this.fEnv.getUMLReflection().getOCLType((Object)feature);
    }

    @Override
    public OCLStandardLibrary<EClassifier> getStandardLibrary() {
        return this.fEnv.getOCLStandardLibrary();
    }

    @Override
    public List<EStructuralFeature> getAllFeatures(EClass eClass) {
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        features.addAll((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        if (eClass instanceof Module) {
            Iterator it = features.iterator();
            while (it.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)it.next();
                if (!(feature instanceof ContextualProperty)) continue;
                it.remove();
            }
        }
        this.collectIntermediateProperties(features, eClass);
        return features;
    }

    @Override
    public QvtOperationalEvaluationEnv getEvalEnv() {
        return this.fEvalEnv;
    }

    @Override
    public Object getValue(EStructuralFeature feature, EObject target) {
        return this.fEvalEnv.navigateProperty(feature, null, (Object)target);
    }

    private void collectIntermediateProperties(List<EStructuralFeature> properties, EClass targetClass) {
        QvtOperationalEvaluationEnv evalEnv = this.fEvalEnv;
        InternalEvaluationEnv internEvalEnv = (InternalEvaluationEnv)evalEnv.getAdapter(InternalEvaluationEnv.class);
        ModuleInstance currentModule = internEvalEnv.getCurrentModule();
        if (currentModule instanceof TransformationInstance) {
            this.collectIntermediateProperties(properties, targetClass, (TransformationInstance)currentModule);
        }
    }

    private void collectIntermediateProperties(List<EStructuralFeature> properties, EClass targetClass, TransformationInstance scopeModule) {
        OperationalTransformation operationalTransformation = scopeModule.getTransformation();
        for (EStructuralFeature nextProperty : operationalTransformation.getIntermediateProperty()) {
            ContextualProperty ctxProperty;
            if (!(nextProperty instanceof ContextualProperty) || !(ctxProperty = (ContextualProperty)nextProperty).getContext().isSuperTypeOf(targetClass)) continue;
            properties.add((EStructuralFeature)ctxProperty);
        }
        for (ModuleInstance importedModule : scopeModule.getImportedModules()) {
            if (!(importedModule instanceof TransformationInstance)) continue;
            this.collectIntermediateProperties(properties, targetClass, (TransformationInstance)importedModule);
        }
    }
}

