/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.FileUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.ExeXMISerializer;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.nature.NatureUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTOBuilder
extends IncrementalProjectBuilder {
    public static final String SAVE_AST_XMI = "internal.save.xmi";
    private QVTOBuilderConfig myConfig;

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(monitor);
            }
            IProject[] iProjectArray = this.getConfig().getProjectDependencies(true);
            return iProjectArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.rebuildAll(monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        try {
            final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Clean " + this.getProject().getName()), (int)2);
            this.getProject().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    boolean isFile;
                    subMonitor.setWorkRemaining(2);
                    boolean bl = isFile = proxy.getType() == 1;
                    if (isFile && "qvto".equals(proxy.requestFullPath().getFileExtension())) {
                        proxy.requestResource().deleteMarkers("org.eclipse.m2m.qvt.oml.project.QVTOProblem", true, 2);
                    }
                    subMonitor.worked(1);
                    return !isFile;
                }
            }, 2);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void incrementalBuild(IProgressMonitor monitor) throws CoreException {
        boolean needsRebuild = this.hasQVTModification(this.getProject());
        if (!needsRebuild) {
            IProject[] referencedProjects = this.getConfig().getProjectDependencies(true);
            int i = 0;
            while (i < referencedProjects.length) {
                IProject refProject = referencedProjects[i];
                boolean bl = needsRebuild = !refProject.isAccessible() || this.hasQVTModification(refProject);
                if (needsRebuild) break;
                ++i;
            }
        }
        if (needsRebuild) {
            this.rebuildAll(monitor);
        }
    }

    private boolean hasQVTModification(final IProject project) throws CoreException {
        IResourceDelta delta = this.getDelta(project);
        final boolean[] rebuild = new boolean[1];
        if (delta != null) {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if ((delta.getFlags() & 0x1000) != 0 && 2 == delta.getResource().getType()) {
                        IContainer srcContainer = QVTOBuilderConfig.getConfig(project).getSourceContainer();
                        if (delta.getMovedFromPath().equals((Object)srcContainer.getFullPath())) {
                            try {
                                QVTOBuilderConfig config = QVTOBuilderConfig.getConfig(project);
                                config.setSourceContainer((IContainer)((IFolder)delta.getResource()));
                                config.save();
                            }
                            catch (CoreException e) {
                                QvtPlugin.getDefault().log((Object)e.getStatus());
                            }
                        }
                    }
                    if (delta.getResource().getType() == 1) {
                        IPath projectRelativePath = delta.getResource().getProjectRelativePath();
                        if (".project".equals(projectRelativePath.toString()) || "plugin.xml".equals(projectRelativePath.toString()) || "META-INF/MANIFEST.MF".equals(projectRelativePath.toString())) {
                            rebuild[0] = true;
                            return false;
                        }
                        if ("qvto".equals(projectRelativePath.getFileExtension())) {
                            rebuild[0] = true;
                            return false;
                        }
                        IFile mappingsFile = MetamodelURIMappingHelper.getMappingFileHandle((IProject)project);
                        if (mappingsFile != null && mappingsFile.exists() && projectRelativePath.equals((Object)mappingsFile.getProjectRelativePath())) {
                            rebuild[0] = true;
                            return false;
                        }
                        if (delta.getResource().getType() == 1 && MetamodelRegistry.isMetamodelFileName((String)delta.getResource().getName())) {
                            rebuild[0] = true;
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        return rebuild[0];
    }

    private void rebuildAll(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Build " + this.getProject().getName()), (int)10);
        try {
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setGenerateCompletionData(false);
            QVTOCompiler compiler = CompilerUtils.createCompiler();
            List allUnits = UnitResolverFactory.Registry.INSTANCE.findAllUnits(URIUtils.getResourceURI((IResource)this.getProject()));
            subMonitor.worked(1);
            if (monitor.isCanceled()) {
                CompilerUtils.throwOperationCanceled();
            } else if (this.isInterrupted()) {
                return;
            }
            CompiledUnit[] units = compiler.compile(allUnits.toArray(new UnitProxy[allUnits.size()]), options, (IProgressMonitor)subMonitor.newChild(8, 0));
            if (this.shouldSaveXMI()) {
                ResourceSet metamodelResourceSet = compiler.getResourceSet();
                EPackage.Registry registry = MetamodelURIMappingHelper.mappingsToEPackageRegistry((IProject)this.getProject(), (ResourceSet)metamodelResourceSet);
                ExeXMISerializer.saveUnitXMI((CompiledUnit[])units, (EPackage.Registry)(registry != null ? registry : EPackage.Registry.INSTANCE));
                subMonitor.worked(1);
            }
            subMonitor.setWorkRemaining(units.length);
            int i = 0;
            while (i < units.length) {
                if (monitor.isCanceled()) {
                    CompilerUtils.throwOperationCanceled();
                } else if (this.isInterrupted()) {
                    return;
                }
                try {
                    CompiledUnit nextUnit = units[i];
                    URI sourceURI = nextUnit.getURI();
                    IFile sourceFile = URIUtils.getFile((URI)sourceURI);
                    sourceFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    List messages = nextUnit.getProblems();
                    for (QvtMessage nextMessage : messages) {
                        this.createQvtMarker(sourceFile, nextMessage);
                    }
                    subMonitor.worked(1);
                    ++i;
                }
                catch (MdaException e) {
                    throw new CoreException(e.getStatus());
                }
                catch (IOException e) {
                    throw new CoreException(QVTOProjectPlugin.createStatus(4, e.getMessage(), e));
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void createQvtMarker(IFile curFile, QvtMessage e) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("charStart", e.getOffset());
        attributes.put("charEnd", e.getOffset() + e.getLength());
        attributes.put("message", e.getMessage());
        attributes.put("severity", this.convertSeverity((Diagnostic)e));
        if (e.getLineNum() >= 0) {
            attributes.put("lineNumber", e.getLineNum());
        }
        try {
            IMarker marker = curFile.createMarker("org.eclipse.m2m.qvt.oml.project.QVTOProblem");
            marker.setAttributes(attributes);
        }
        catch (CoreException e1) {
            Logger.getLogger().log(Logger.WARNING, "QVTOBuilder: failed to create marker", e1);
        }
    }

    private int convertSeverity(Diagnostic diagnostic) {
        switch (diagnostic.getSeverity()) {
            case 4: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    private QVTOBuilderConfig getConfig() throws CoreException {
        if (this.myConfig == null) {
            this.myConfig = QVTOBuilderConfig.getConfig(this.getProject());
        }
        return this.myConfig;
    }

    public static String getFileContents(IFile file) {
        try {
            return FileUtil.getStreamContents((InputStream)file.getContents(), (String)file.getCharset());
        }
        catch (Exception e) {
            return "";
        }
    }

    private boolean shouldSaveXMI() {
        try {
            ICommand buildCommand = NatureUtils.findCommand(this.getProject(), "org.eclipse.m2m.qvt.oml.project.QVTOBuilder");
            if (buildCommand != null) {
                Map arguments = buildCommand.getArguments();
                Object strValue = arguments.get(SAVE_AST_XMI);
                return Boolean.valueOf(String.valueOf(strValue));
            }
        }
        catch (CoreException e) {
            QVTOProjectPlugin.log(e);
        }
        return false;
    }

    public static interface BuildListener {
        public void buildPerformed();
    }
}

