/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtKeywords;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtWhitespaceDetector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.IQVTColors;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.QVTColorManager;

public class QvtScanner
extends RuleBasedScanner {
    private static final String[] IGNORED_KWDS = new String[]{"String", "Boolean", "Integer", "Real", "OclVoid"};

    public QvtScanner(QVTColorManager manager) {
        Token keyWord = manager.getColor(IQVTColors.KEYWORD).createToken();
        Token defaultToken = manager.getColor(IQVTColors.DEFAULT).createToken();
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new QvtWhitespaceDetector()));
        WordRule wordRule = new WordRule(new IWordDetector(){

            public boolean isWordPart(char character) {
                return Character.isJavaIdentifierPart(character);
            }

            public boolean isWordStart(char character) {
                return Character.isJavaIdentifierStart(character);
            }
        }, (IToken)defaultToken);
        this.addKeywords(wordRule, (IToken)keyWord);
        rules.add(wordRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private void addKeywords(WordRule wordRule, IToken keyWord) {
        HashSet<String> ignored = new HashSet<String>(Arrays.asList(IGNORED_KWDS));
        for (String keyword : QvtKeywords.KEYWORDS) {
            if (ignored.contains(keyword)) continue;
            wordRule.addWord(keyword, keyWord);
        }
    }
}

