/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QVTOEnvironment;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.ExceptionInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.StatusInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.StdlibFactory;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.ocl.types.OCLStandardLibrary;

public class TransformationOperations
extends AbstractContextualOperations {
    static final String TRANSFORM_NAME = "transform";
    static final String PARALLEL_TRANSFORM_NAME = "parallelTransform";
    static final String WAIT_NAME = "wait";

    public TransformationOperations(AbstractQVTStdlib library) {
        super(library, (EClassifier)library.getTransformationClass());
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        QVTOEnvironment environment = this.getStdlib().getEnvironment();
        OCLStandardLibrary oclStdLibrary = environment.getOCLStandardLibrary();
        ListType statusList = environment.getTypeResolver().resolveListType((EClassifier)oclStdLibrary.getT());
        return new AbstractContextualOperations.OwnedOperationProvider[]{(AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(TransformationOperations.createTransformHandler(this.getStdlib()), TRANSFORM_NAME, (EClassifier)this.getStdlib().getStatusClass(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, PARALLEL_TRANSFORM_NAME, (EClassifier)this.getStdlib().getStatusClass(), new EClassifier[0]), (AbstractContextualOperations)this.new AbstractContextualOperations.OwnedOperationProvider(UNSUPPORTED_OPER, WAIT_NAME, new String[]{"statusList"}, (EClassifier)oclStdLibrary.getOclVoid(), new EClassifier[]{statusList})};
    }

    private static CallHandler createTransformHandler(AbstractQVTStdlib stdlib) {
        return new CallHandler(){

            public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                ModuleInstance moduleInstance = (ModuleInstance)source;
                CallHandler mainHandler = moduleInstance.getAdapter(TransformationInstance.InternalTransformation.class).getEntryOperationHandler();
                if (mainHandler == null) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                StdlibFactory stdlibFactory = QvtOperationalStdLibrary.INSTANCE.getStdlibFactory();
                try {
                    mainHandler.invoke(moduleInstance, source, args, evalEnv);
                }
                catch (QvtInterruptedExecutionException e) {
                    evalEnv.getAdapter(InternalEvaluationEnv.class).setException(e);
                    throw e;
                }
                catch (QvtRuntimeException e) {
                    ExceptionInstance raisedException = stdlibFactory.createException(e.getLocalizedMessage(), e.getQvtStackTrace());
                    StatusInstance status = stdlibFactory.createFailure(raisedException);
                    return status;
                }
                return stdlibFactory.createSuccess();
            }
        };
    }
}

