/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.debugger;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.m2m.internal.qvt.oml.common.io.FileUtil;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.RetargettableActionAdapterFactory;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilder;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.DebugEventLogger;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.MarkedTransformation;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.Script;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOBreakpoint;
import org.eclipse.m2m.qvt.oml.debug.core.launch.QVTODebugConfiguration;
import org.eclipse.m2m.qvt.oml.debug.core.srclookup.QVTOSourceLookupDirector;
import org.eclipse.m2m.tests.qvt.oml.TestProject;
import org.eclipse.m2m.tests.qvt.oml.transform.ModelTestData;
import org.eclipse.m2m.tests.qvt.oml.util.ReaderInputStream;
import org.eclipse.m2m.tests.qvt.oml.util.TestUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class TestQvtoDebugger
extends TestCase {
    private static TestProject myProject;
    private static ILaunchConfigurationWorkingCopy myLaunchConfigurationWorkingCopy;
    private DebugEventLogger myListener;
    private Script myScript;
    private MarkedTransformation myMarkedTrans;
    private static final String PROJECT_NAME = "DebuggerTest";
    private static final String CONFIG_NAME = "debugConfig";
    private static final String TEST_DATA_FOLDER = "debuggerTestData";
    private static final String MARKED_TEST_FILE = "markedTest.qvto";
    private static final String TEST_FILE = "test.qvto";
    private static final String IN_MODEL = "in.ecore";
    private static final String TRACE_FILE = "in.ecore.trace";
    private static final String SCRIPT_FILE = "test.xml";
    private static final String LOADING_TEST_MESSAGE = "DebuggerTester: Loading test {0}";
    private static final String RUNNING_DEBUGGER_MESSAGE = "DebuggerTester: Running debugger...";
    private static final String TEST_FINISHED_MESSAGE = "DebuggerTester: Debugging finished: {0}";
    private static final String BREAKPOINT_SET_MESSAGE = "Breakpoint set incorrectly: {0} in {1}";
    private static final String BREAKPOINT_NOT_SET_MESSAGE = "Breakpoint not set incorrectly: {0} in {1}";
    private static final String WRONG_LINE_NUMBER_MESSAGE = "Line numbers don''t correspond: {0} vs {1}.";
    private static final String WRONG_CAUSE_MESSAGE = "Stop causes don''t correspond: {0} vs \"{1}\".";
    private static final String SCRIPT_NOT_FINISHED_MESSAGE = "Script not finished: {0}";

    public TestQvtoDebugger(ModelTestData data) {
        super(data.getName());
    }

    public void setUp() throws Exception {
        if (myProject != null) {
            return;
        }
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                DebugUIPlugin.getDefault().getPreferenceStore().putValue("org.eclipse.debug.ui.switch_to_perspective", "never");
                DebugUIPlugin.getDefault().getPreferenceStore().putValue("org.eclipse.debug.ui.activate_debug_view", Boolean.FALSE.toString());
                DebugUIPlugin.getDefault().getPreferenceStore().putValue("org.eclipse.debug.ui.switch_perspective_on_suspend", "never");
            }
        });
        TestUtil.turnOffAutoBuilding();
        myProject = new TestProject(PROJECT_NAME, new String[0]);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.m2m.qvt.oml.QvtTransformation");
        myLaunchConfigurationWorkingCopy = type.newInstance(null, CONFIG_NAME);
        this.copyModelData(TestUtil.getPluginRelativeFile((String)"org.eclipse.m2m.tests.qvt.oml.ui", (String)"debuggerTestData/tests"));
    }

    public void tearDown() throws Exception {
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) != null) {
            activePage.closeEditor(activeEditor, false);
        }
    }

    protected void runTest() throws Throwable {
        this.doTest(this.getName());
    }

    private void copyModelData(File srcFolder) throws Exception {
        File folder = new File(String.valueOf(myProject.getProject().getLocation().toString()) + "/" + TEST_DATA_FOLDER);
        folder.mkdirs();
        FileUtil.copyFolder((File)srcFolder, (File)folder);
        myProject.getProject().refreshLocal(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDebugger(int time) throws InterruptedException {
        TestQvtoDebugger testQvtoDebugger = this;
        synchronized (testQvtoDebugger) {
            if (time > 0) {
                ((Object)((Object)this)).wait(time);
            } else {
                ((Object)((Object)this)).wait();
            }
        }
    }

    private void addBreakpoint(QvtEditor qvtEditor, final int line) throws CoreException, OperationCanceledException, InterruptedException {
        IToggleBreakpointsTarget breakpointAdapter = (IToggleBreakpointsTarget)new RetargettableActionAdapterFactory().getAdapter((Object)qvtEditor, IToggleBreakpointsTarget.class);
        breakpointAdapter.toggleLineBreakpoints((IWorkbenchPart)qvtEditor, (ISelection)new ITextSelection(){

            public boolean isEmpty() {
                return false;
            }

            public String getText() {
                return null;
            }

            public int getStartLine() {
                return line - 1;
            }

            public int getOffset() {
                return 0;
            }

            public int getLength() {
                return 1;
            }

            public int getEndLine() {
                return this.getStartLine();
            }
        });
        IJobManager jobMan = Job.getJobManager();
        jobMan.join(QVTOBreakpoint.QVTO_BREAKPOINT_JOBFAMILY, (IProgressMonitor)new NullProgressMonitor());
    }

    private String getProjectFileName(String folder, String file) {
        return String.valueOf(TestQvtoDebugger.myProject.project.getName()) + "/" + TEST_DATA_FOLDER + "/" + folder + "/" + file;
    }

    private String getProjectFilePath(String folder, String file) {
        return MessageFormat.format("{0}/{1}/{2}/{3}", TestQvtoDebugger.myProject.project.getLocation(), TEST_DATA_FOLDER, folder, file);
    }

    private void setTestData(String folder) throws Exception {
        String markedName = this.getProjectFileName(folder, MARKED_TEST_FILE);
        IFile markedFile = WorkspaceUtils.getWorkspaceFile((String)markedName);
        String markedData = QVTOBuilder.getFileContents((IFile)markedFile);
        this.myMarkedTrans = new MarkedTransformation(markedData);
        String testName = this.getProjectFileName(folder, TEST_FILE);
        IFile testFile = WorkspaceUtils.getWorkspaceFile((String)testName);
        testFile.delete(false, null);
        testFile.create((InputStream)new ReaderInputStream(this.myMarkedTrans.getCleanText()), true, null);
        myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", URIUtils.getResourceURI((IResource)testFile).toString());
        QvtLaunchUtil.saveTargetUriData((ILaunchConfigurationWorkingCopy)myLaunchConfigurationWorkingCopy, (TargetUriData)new TargetUriData(TargetUriData.TargetType.EXISTING_CONTAINER, URI.createPlatformResourceURI((String)this.getProjectFileName(folder, IN_MODEL), (boolean)true).toString(), null, false), (int)1);
        myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.elemCount", 1);
        myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", this.getProjectFileName(folder, TRACE_FILE));
        myLaunchConfigurationWorkingCopy.doSave();
        this.myScript = new Script(this.getProjectFilePath(folder, SCRIPT_FILE), this.myMarkedTrans);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        QvtEditor qvtEditor = (QvtEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)testFile);
        qvtEditor.getValidCompiledModule(10000L);
        for (MarkedTransformation.LineMarker rec : this.myMarkedTrans.getBreakpointLineMarkers()) {
            this.addBreakpoint(qvtEditor, rec.lineNumber);
        }
    }

    private void runDebugger() throws CoreException, InterruptedException {
        ILaunchConfiguration config = myLaunchConfigurationWorkingCopy.doSave();
        QVTODebugConfiguration debugConfig = new QVTODebugConfiguration();
        Launch launch = new Launch(config, "debug", (ISourceLocator)new QVTOSourceLookupDirector());
        this.myListener = new DebugEventLogger((Object)this, this.myScript);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.myListener);
        debugConfig.launch(config, "debug", (ILaunch)launch, (IProgressMonitor)new NullProgressMonitor());
        while (!launch.isTerminated()) {
            while (Display.getDefault().readAndDispatch()) {
            }
            Thread.sleep(10L);
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.myListener);
    }

    private void doTest(String folder) throws Exception {
        System.out.println(MessageFormat.format(LOADING_TEST_MESSAGE, folder));
        this.setTestData(folder);
        System.out.println(RUNNING_DEBUGGER_MESSAGE);
        this.runDebugger();
        System.out.println(MessageFormat.format(TEST_FINISHED_MESSAGE, folder));
        Collection<MarkedTransformation.LineMarker> allBreakpoints = this.myMarkedTrans.getBreakpointLineMarkers();
        Set<Integer> physicalBreakpoints = this.getPhysicalBreakpoints();
        for (MarkedTransformation.LineMarker lineMarker : allBreakpoints) {
            TestQvtoDebugger.assertTrue((String)MessageFormat.format(lineMarker.fail ? BREAKPOINT_SET_MESSAGE : BREAKPOINT_NOT_SET_MESSAGE, lineMarker, myLaunchConfigurationWorkingCopy.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", "")), (!physicalBreakpoints.contains(lineMarker.lineNumber) == lineMarker.fail ? 1 : 0) != 0);
        }
        for (DebugEventLogger.LogRecord logRecord : this.myListener.getLog()) {
            System.out.println(logRecord.toString(this.myMarkedTrans));
            TestQvtoDebugger.assertTrue((String)MessageFormat.format(WRONG_LINE_NUMBER_MESSAGE, logRecord.getCommand(), logRecord.toString()), (logRecord.getLineNumber() == logRecord.getCommand().lineNumber ? 1 : 0) != 0);
            TestQvtoDebugger.assertTrue((String)MessageFormat.format(WRONG_CAUSE_MESSAGE, logRecord.getCommand(), DebugEventLogger.LogRecord.eventDetailToString(logRecord.getEventDetail())), (logRecord.getEventDetail() == logRecord.getCommand().getEventDetail() ? 1 : 0) != 0);
        }
        TestQvtoDebugger.assertFalse((String)MessageFormat.format(SCRIPT_NOT_FINISHED_MESSAGE, this.getProjectFileName(folder, SCRIPT_FILE)), (boolean)this.myScript.hasNextCommand());
    }

    private Set<Integer> getPhysicalBreakpoints() throws CoreException {
        HashSet<Integer> physicalBreakpoints = new HashSet<Integer>();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] qvtBreakpoints = manager.getBreakpoints("org.eclipse.m2m.qvt.oml.debug");
        int i = 0;
        while (i < qvtBreakpoints.length) {
            QVTOBreakpoint breakpoint;
            if (qvtBreakpoints[i] instanceof QVTOBreakpoint && (breakpoint = (QVTOBreakpoint)qvtBreakpoints[i]).isEnabled()) {
                physicalBreakpoints.add(breakpoint.getLineNumber());
            }
            ++i;
        }
        return physicalBreakpoints;
    }
}

