/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.project.QvtProjectUtil;
import org.eclipse.m2m.internal.qvt.oml.project.nature.NatureUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ProjectDependencyTracker;
import org.eclipse.osgi.util.NLS;

public class QVTOBuilderConfig {
    private static final String SRC_CONTAINER = "src_container";
    private static final String PROJECT_ROOT = "/";
    private final IProject myProject;
    private ICommand myCommand;
    private String myBuilderID;

    public QVTOBuilderConfig(IProject project, String builderID) throws CoreException {
        this.myProject = project;
        this.myBuilderID = builderID;
        this.myCommand = NatureUtils.findCommand(this.myProject, this.myBuilderID);
    }

    public static QVTOBuilderConfig getConfig(IProject project) throws CoreException {
        QVTOBuilderConfig config = new QVTOBuilderConfig(project, "org.eclipse.m2m.qvt.oml.project.QVTOBuilder");
        return config;
    }

    public boolean isInSourceContainer(IResource resource) {
        IContainer container = null;
        if (resource.exists() && this.myProject.equals((Object)resource.getProject())) {
            container = this.getSourceContainer();
        }
        if (container != null && container.exists()) {
            return container.getProjectRelativePath().isPrefixOf(resource.getProjectRelativePath());
        }
        return false;
    }

    public void save() throws CoreException {
        NatureUtils.updateCommand(this.myProject, this.myCommand);
    }

    public boolean getGenerateJava() {
        return false;
    }

    public IContainer getDefaultSourceContainer() {
        return this.myProject;
    }

    public IContainer getSourceContainer() {
        IContainer containerPath = this.getRawSourceContainer();
        if (containerPath == null) {
            return this.myProject;
        }
        return containerPath;
    }

    public IContainer getRawSourceContainer() {
        String containerPath = this.getArgument(SRC_CONTAINER);
        if (containerPath != null) {
            Path path = new Path(containerPath);
            if (path.isRoot()) {
                return this.myProject;
            }
            return this.myProject.getFolder((IPath)path);
        }
        return null;
    }

    public void setSourceContainer(IContainer container) {
        if (container.getProject() != this.myProject) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.InvalidSourceContainer, (Object)container.getFullPath()));
        }
        try {
            IProjectDescription pd = this.myProject.getProject().getDescription();
            NatureUtils.addBuilders(pd, new String[]{this.myBuilderID}, new String[0]);
            ICommand[] buildSpec = pd.getBuildSpec();
            if (this.myCommand == null) {
                this.myCommand = NatureUtils.findCommand(buildSpec, this.myBuilderID);
            }
            if (this.myCommand != null) {
                this.setBuildCommandArgument(SRC_CONTAINER, this.getPathString(container));
                int i = 0;
                while (i < buildSpec.length) {
                    if (this.myBuilderID.equals(buildSpec[i].getBuilderName())) {
                        buildSpec[i] = this.myCommand;
                    }
                    ++i;
                }
                pd.setBuildSpec(buildSpec);
            }
            this.myProject.getProject().setDescription(pd, null);
        }
        catch (CoreException e) {
            QvtPlugin.getDefault().log((Object)e.getStatus());
        }
    }

    public void addTransformationNature() {
        try {
            NatureUtils.addNature(this.myProject, "org.eclipse.m2m.qvt.oml.project.QVTONature");
        }
        catch (CoreException e) {
            QvtPlugin.getDefault().log((Object)e.getStatus());
        }
    }

    public IContainer[] getQvtContainers() {
        ArrayList<IContainer> containers = new ArrayList<IContainer>();
        containers.add(this.getSourceContainer());
        try {
            Set referencedProjects = ProjectDependencyTracker.getAllReferencedProjects((IProject)this.myProject, (boolean)true);
            for (IProject nextProject : referencedProjects) {
                if (!QvtProjectUtil.isQvtProject(nextProject)) continue;
                containers.add(QVTOBuilderConfig.getConfig(nextProject).getSourceContainer());
            }
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Can't get QVT source containers", e);
        }
        return containers.toArray(new IContainer[containers.size()]);
    }

    public IProject[] getProjectDependencies(boolean recursive) {
        return ProjectDependencyTracker.getAllReferencedProjects((IProject)this.myProject, (boolean)recursive).toArray(new IProject[0]);
    }

    private String getPathString(IContainer container) {
        String containerPath = container == this.myProject ? PROJECT_ROOT : container.getProjectRelativePath().toString();
        return containerPath;
    }

    private String getArgument(String name) {
        if (this.myCommand == null) {
            return null;
        }
        Map arguments = this.myCommand.getArguments();
        if (arguments == null) {
            return null;
        }
        return (String)this.myCommand.getArguments().get(name);
    }

    private void setBuildCommandArgument(String name, String value) {
        assert (this.myCommand != null);
        if (this.myCommand == null) {
            return;
        }
        HashMap<String, String> arguments = this.myCommand.getArguments();
        if (arguments == null) {
            arguments = new HashMap<String, String>();
        }
        arguments.put(name, value);
        this.myCommand.setArguments(arguments);
    }
}

