/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.compiler.EmfStandaloneMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfStandaloneMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.ProjectMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;

public class ProjectMetamodelRegistryProvider
implements IMetamodelRegistryProvider {
    private ResourceSet resolutionRSet;
    private Map<String, MetamodelRegistry> perProjectRegs;
    private IMetamodelRegistryProvider delegateProvider;
    private EPackage.Registry delegateRegistry;

    public ProjectMetamodelRegistryProvider() {
        this(EPackage.Registry.INSTANCE);
    }

    public ProjectMetamodelRegistryProvider(EPackage.Registry registry) {
        this(registry, null);
    }

    public ProjectMetamodelRegistryProvider(ResourceSet resourceSet) {
        this(resourceSet.getPackageRegistry(), resourceSet);
    }

    private ProjectMetamodelRegistryProvider(EPackage.Registry registry, ResourceSet resourceSet) {
        if (registry == null) {
            throw new IllegalArgumentException();
        }
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
            resourceSet.setPackageRegistry((EPackage.Registry)new EPackageRegistryImpl(registry));
        }
        this.resolutionRSet = resourceSet;
        this.delegateRegistry = registry;
        this.delegateProvider = new EmfStandaloneMetamodelRegistryProvider(this.delegateRegistry);
    }

    public ResourceSet getResolutionResourceSet() {
        return this.resolutionRSet;
    }

    public MetamodelRegistry getRegistry(IMetamodelRegistryProvider.IRepositoryContext context) {
        IProject project;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        URI uri = context.getURI();
        if (!uri.isPlatformResource()) {
            return this.delegateProvider.getRegistry(context);
        }
        Path wsLocation = new Path(uri.toPlatformString(true));
        IResource wsResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)wsLocation);
        if (wsResource == null) {
            wsResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)wsLocation);
        }
        if (wsResource != null && MetamodelURIMappingHelper.hasMappingResource((IProject)(project = wsResource.getProject()))) {
            String projectKey;
            MetamodelRegistry reg;
            if (this.perProjectRegs == null) {
                this.perProjectRegs = new HashMap<String, MetamodelRegistry>();
            }
            if ((reg = this.perProjectRegs.get(projectKey = project.getFullPath().toString())) == null) {
                ProjectMetamodelProvider provider = new ProjectMetamodelProvider(project, (IMetamodelProvider)new EmfStandaloneMetamodelProvider(this.delegateRegistry), this.resolutionRSet);
                reg = new MetamodelRegistry((IMetamodelProvider)provider);
                this.perProjectRegs.put(projectKey, reg);
            }
            return reg;
        }
        return this.delegateProvider.getRegistry(context);
    }
}

