/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.qvt.oml.debug.core.IQVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOLocalVariable;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOValue;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMFrameExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VariableFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTOLocalValue
extends QVTOValue {
    private final long myFrameID;
    private final VMFrameExecutionContext myExecContext;

    public QVTOLocalValue(IQVTODebugTarget debugTarget, long frameID, String[] varPath, LocalValue evalResult, VMFrameExecutionContext execContext) {
        super(debugTarget, QVTOLocalValue.createVmVar(varPath, evalResult, execContext.getEvalEnv()), frameID);
        this.myFrameID = frameID;
        this.myExecContext = execContext;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        List<VMVariable> variables = this.requestVariables();
        ArrayList<QVTOLocalVariable> result = new ArrayList<QVTOLocalVariable>();
        for (VMVariable nextVar : variables) {
            result.add(new QVTOLocalVariable(this.getQVTODebugTarget(), nextVar, this.myFrameID, this.myExecContext));
        }
        return result.toArray(new IVariable[result.size()]);
    }

    @Override
    protected List<VMVariable> requestVariables() throws DebugException {
        ArrayList<VMVariable> vars = new ArrayList<VMVariable>();
        new VariableFinder(this.myExecContext, true).collectChildVars(this.vmVar.valueObject, VariableFinder.getVariablePath(VariableFinder.parseURI(this.vmVar.variableURI)), null, vars);
        return vars;
    }

    private static VMVariable createVmVar(String[] varPath, LocalValue evalResult, QvtOperationalEvaluationEnv evalEnv) {
        VMVariable var = new VMVariable();
        var.name = varPath.length > 0 ? varPath[varPath.length - 1] : String.valueOf(null);
        var.kind = 0;
        var.variableURI = VariableFinder.createURI(varPath).toString();
        var.valueObject = evalResult.valueObject;
        VariableFinder.setValueAndType(var, evalResult.valueObject, evalResult.valueType, evalEnv);
        return var;
    }

    public static class LocalValue {
        public Object valueObject;
        public EClassifier valueType;
    }
}

