/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.tools.coverage.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.common.CoverageData;
import org.eclipse.m2m.internal.qvt.oml.tools.coverage.common.TransformationCoverageData;
import org.eclipse.m2m.qvt.oml.tools.coverage.Activator;

public class CoverageDataPersistor {
    private static final String DIR_SEP = System.getProperty("file.separator");
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String DIR_PATH = String.valueOf(TMP_DIR) + DIR_SEP + "CoverageData" + DIR_SEP;

    public CoverageData load() {
        try {
            CoverageData data = new CoverageData();
            File folder = new File(DIR_PATH);
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File transDataFile = fileArray[n2];
                ObjectInputStream stream = new ObjectInputStream(new FileInputStream(transDataFile));
                TransformationCoverageData transData = (TransformationCoverageData)stream.readObject();
                stream.close();
                data.add(transData);
                ++n2;
            }
            return data;
        }
        catch (Exception e) {
            Activator.error("Failed to load coverage data", e);
            return null;
        }
    }

    public void save(CoverageData data) {
        try {
            this.prepareDirectories();
            for (TransformationCoverageData transData : data.getData()) {
                ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(String.valueOf(DIR_PATH) + transData.hashCode()));
                os.writeObject(transData);
                os.close();
            }
        }
        catch (Exception e) {
            Activator.error("Failed to persist coverage data", e);
        }
    }

    private void prepareDirectories() {
        File dir = new File(DIR_PATH);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }
}

