/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.debug.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.QVTODebugUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.qvt.oml.debug.core.vm.ValidBreakpointLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;

class BreakpointLocationVerifier {
    private static final int GET_AST_TIMEOUT = 10000;
    private final ILineBreakpoint fBreakpoint;
    private final QvtEditor fEditor;
    private final String fInvalidLocationMessage;

    private static LineNumberProvider getLineNumberProvider(final IDocument doc) {
        return new LineNumberProvider(){

            public int getLineNumber(int offset) {
                try {
                    return doc.getLineOfOffset(offset) + 1;
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }

            public int getLineEnd(int lineNumber) {
                try {
                    IRegion lineInfo = doc.getLineInformation(lineNumber);
                    return lineInfo.getOffset() + lineInfo.getLength();
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }

            public int getLineCount() {
                return doc.getNumberOfLines();
            }
        };
    }

    BreakpointLocationVerifier(QvtEditor editor, ILineBreakpoint breakpoint, String invalidLocationMessage) {
        if (editor == null || breakpoint == null || invalidLocationMessage == null) {
            throw new IllegalArgumentException();
        }
        this.fEditor = editor;
        this.fBreakpoint = breakpoint;
        this.fInvalidLocationMessage = invalidLocationMessage;
    }

    IStatus run() {
        IStatus status = this.checkBreakpointableElements();
        if (!status.isOK() && this.fBreakpoint != null) {
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
            }
            catch (CoreException e) {
                QVTODebugUIPlugin.log(e.getStatus());
            }
        }
        return status;
    }

    private IStatus checkBreakpointableElements() {
        int lineNumber;
        try {
            lineNumber = this.fBreakpoint.getLineNumber();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        IDocumentProvider docProvider = this.fEditor.getDocumentProvider();
        if (docProvider == null) {
            return this.canceled();
        }
        IDocument doc = docProvider.getDocument((Object)this.fEditor.getEditorInput());
        if (doc == null) {
            return this.canceled();
        }
        CompiledUnit compilationUnit = this.fEditor.getValidCompiledModule(10000L);
        if (compilationUnit == null) {
            return QVTODebugUIPlugin.createErrorStatus("Failed to obtain AST");
        }
        List elements = ValidBreakpointLocator.getBreakpointableElementsForLine((CompiledUnit)compilationUnit, (LineNumberProvider)BreakpointLocationVerifier.getLineNumberProvider(doc), (int)lineNumber);
        if (elements.isEmpty()) {
            this.report(NLS.bind((String)this.fInvalidLocationMessage, (Object)new Integer(lineNumber)));
            return this.canceled();
        }
        return Status.OK_STATUS;
    }

    protected void report(final String message) {
        QVTODebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)BreakpointLocationVerifier.this.fEditor.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    statusLine.setMessage(true, message, null);
                }
                if (message != null && QVTODebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    private IStatus canceled() {
        return QVTODebugUIPlugin.createStatus(8, this.fInvalidLocationMessage);
    }
}

