/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseContainer;

public class EclipseResource
implements CResource {
    protected final IResource myResource;

    public EclipseResource(IResource resource) {
        this.myResource = resource;
    }

    public String getName() {
        return this.myResource.getName();
    }

    public String getExtension() {
        return this.myResource.getFileExtension();
    }

    public String getFullPath() {
        IPath location = this.myResource.getLocation();
        if (location != null) {
            return location.toOSString();
        }
        String fullName = this.getParent() == null ? this.getName() : String.valueOf(this.getParent().getFullPath()) + File.separator + this.getName();
        return fullName;
    }

    public boolean exists() {
        return this.myResource.exists();
    }

    public CFolder getParent() {
        IContainer parent = this.myResource.getParent();
        if (parent == null) {
            return null;
        }
        return EclipseContainer.makeFolder(parent);
    }

    public void delete() throws IOException {
        try {
            this.myResource.delete(true, null);
        }
        catch (CoreException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    public void refresh() throws IOException {
        try {
            this.myResource.refreshLocal(2, null);
        }
        catch (CoreException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }

    public boolean equals(Object other) {
        return other instanceof EclipseResource && ((EclipseResource)other).myResource.equals((Object)this.myResource);
    }

    public int hashCode() {
        return this.myResource.hashCode();
    }

    public String toString() {
        return String.valueOf(this.myResource);
    }

    public IResource getResource() {
        return this.myResource;
    }
}

