/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.m2m.internal.qvt.oml.TransformationRunner;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.debug.core.launch.TransformationRunnerFactory;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;

public class QVTOApplication
implements IApplication {
    public static final String ID = "org.eclipse.m2m.qvt.oml.debug.QVTOApplication";
    public static final String ARG_PORT = "-port";
    public static final String ARG_TRANSFORMATION = "-transform";
    public static final String ARG_PARAM = "-param";
    public static final String ARG_TRACE = "-trace";
    public static final String ARG_HELP = "-help";
    private static final String CMD_LINE_USAGE = "org.eclipse.m2m.qvt.oml.debug.QVTOApplication" + QVTOApplication.squareBracket("-transform uri") + " " + QVTOApplication.squareBracket("-param uri") + " ... " + QVTOApplication.squareBracket("-trace uri") + " ... " + QVTOApplication.squareBracket("-help");
    private TransformationRunnerFactory fRunnerFactory;
    private ExecutionContext fContext;

    public Object start(IApplicationContext context) throws Exception {
        int exitCode = 0;
        if (this.processCommandLine(context)) {
            try {
                exitCode = this.doRun(this.createRunner());
            }
            catch (DiagnosticException e) {
                exitCode = -1;
                System.err.println(e.getDiagnostic());
            }
        } else {
            exitCode = -1;
            System.err.println(this.getCommandLineUsage());
        }
        return new Integer(exitCode);
    }

    public void stop() {
    }

    protected int doRun(TransformationRunner runner) {
        Diagnostic diagnostic = runner.execute(this.getExecutionContext());
        if (diagnostic.getSeverity() == 4) {
            System.err.println(diagnostic);
            return -1;
        }
        return 0;
    }

    protected final TransformationRunnerFactory getRunnerFactory() {
        if (this.fRunnerFactory == null) {
            this.fRunnerFactory = this.createRunnerFactory();
        }
        return this.fRunnerFactory;
    }

    protected TransformationRunnerFactory createRunnerFactory() {
        return new TransformationRunnerFactory();
    }

    protected boolean processCommandLine(IApplicationContext context) {
        String[] argsArray = (String[])context.getArguments().get("application.args");
        boolean hasError = false;
        String[] stringArray = argsArray;
        int n = argsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nextArg = stringArray[n2];
            boolean processResult = this.processCommandLineArg(nextArg);
            hasError = hasError && processResult;
            ++n2;
        }
        return !hasError;
    }

    protected boolean processCommandLineArg(String nextArg) {
        TransformationRunnerFactory factory = this.getRunnerFactory();
        if (factory.modelParamURI == null) {
            factory.modelParamURI = new ArrayList<String>();
        }
        if (QVTOApplication.isValueSpecArg(ARG_TRANSFORMATION, nextArg)) {
            String val;
            factory.transformationURI = val = QVTOApplication.getArgValue(ARG_TRANSFORMATION, nextArg);
        } else if (QVTOApplication.isValueSpecArg(ARG_PARAM, nextArg)) {
            String val = QVTOApplication.getArgValue(ARG_PARAM, nextArg);
            factory.modelParamURI.add(val);
        } else if (QVTOApplication.isValueSpecArg(ARG_TRACE, nextArg)) {
            String val;
            factory.traceFileURI = val = QVTOApplication.getArgValue(ARG_TRACE, nextArg);
        } else if (ARG_HELP.equals(nextArg)) {
            System.out.println(this.getCommandLineUsage());
        } else {
            System.err.println("Unsupported argument: " + nextArg);
            return false;
        }
        return true;
    }

    protected TransformationRunner createRunner() throws DiagnosticException {
        TransformationRunner runner = this.getRunnerFactory().createRunner();
        return runner;
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLog((Log)new WriterLog((Writer)new PrintWriter(System.out), true));
        return context;
    }

    protected final ExecutionContext getExecutionContext() {
        if (this.fContext == null) {
            this.fContext = this.createExecutionContext();
        }
        return this.fContext;
    }

    protected String getCommandLineUsage() {
        return CMD_LINE_USAGE;
    }

    protected static boolean isValueSpecArg(String argName, String argDef) {
        if (argDef.startsWith(argName)) {
            String spec = argDef.substring(argName.length());
            return spec.length() > 1 && spec.charAt(0) == '=';
        }
        return false;
    }

    protected static String getArgValue(String argName, String argDef) {
        String spec;
        if (argDef.startsWith(argName) && (spec = argDef.substring(argName.length())).length() > 1 && spec.charAt(0) == '=') {
            return spec.substring(1);
        }
        throw new IllegalArgumentException("no value in argument" + argDef);
    }

    private static String squareBracket(String str) {
        return "[" + str + "]";
    }
}

