/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import java.util.Collection;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.AbstractCollector;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralFeatureCollector
extends AbstractCollector {
    private static final String SCTRUCTURALFEATURE_CONTAINER_FLAG = StructuralFeatureCollector.class + "SCTRUCTURALFEATURE_CONTAINER_FLAG";
    private static final int[] SCTRUCTURALFEATURE_CONTAINER_TERMINALS = new int[]{47, 89};
    private static final int[] SCTRUCTURALFEATURE_CONTAINER_TERMINALS_WITH_MAPPING_CLAUSES = LightweightParserUtil.uniteIntArrays(SCTRUCTURALFEATURE_CONTAINER_TERMINALS, LightweightParserUtil.MAPPING_CLAUSE_TOKENS);

    @Override
    protected boolean isApplicableInternal(QvtCompletionData data) {
        IToken structuralFeatureContainerToken;
        IToken leftToken = data.getLeftToken();
        if ((leftToken.getKind() == 51 || leftToken.getKind() == 61 || leftToken.getKind() == 64) && (structuralFeatureContainerToken = data.getParentBracingExpression(new QvtCompletionData.ITokenQualificator(){

            public boolean isSuited(IToken token) {
                return QvtCompletionData.isKindOf(token, SCTRUCTURALFEATURE_CONTAINER_TERMINALS_WITH_MAPPING_CLAUSES);
            }
        }, 61, 64, 1, null, null, LightweightParserUtil.MAPPING_CLAUSE_TOKENS)) != null && QvtCompletionData.isKindOf(structuralFeatureContainerToken, SCTRUCTURALFEATURE_CONTAINER_TERMINALS)) {
            data.getUserData().put(SCTRUCTURALFEATURE_CONTAINER_FLAG, structuralFeatureContainerToken);
            return true;
        }
        return false;
    }

    @Override
    public void addPropoposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        OCLExpression<EClassifier> oclExpression;
        IToken structuralFeatureContainerToken = (IToken)data.getUserData().get(SCTRUCTURALFEATURE_CONTAINER_FLAG);
        IToken[] typeTokens = null;
        EClassifier objectExpType = null;
        if (structuralFeatureContainerToken.getKind() == 89) {
            typeTokens = StructuralFeatureCollector.extractMappingType(structuralFeatureContainerToken);
        } else {
            IToken firstTypeToken = LightweightParserUtil.getNextToken(structuralFeatureContainerToken);
            if (firstTypeToken != null) {
                if (QvtCompletionData.isKindOf(firstTypeToken, 61)) {
                    IToken mappingToken = data.getParentBracingExpression(new QvtCompletionData.ITokenQualificator(){

                        public boolean isSuited(IToken token) {
                            return QvtCompletionData.isKindOf(token, 89);
                        }
                    }, 61, 64, 2, null, null, LightweightParserUtil.MAPPING_CLAUSE_TOKENS);
                    if (mappingToken != null) {
                        typeTokens = StructuralFeatureCollector.extractMappingType(mappingToken);
                    }
                } else {
                    IToken[] tokens = QvtCompletionData.extractTokens(firstTypeToken, 61);
                    if (tokens != null && tokens.length >= 2 && QvtCompletionData.isKindOf(tokens[1], 63)) {
                        if (tokens.length == 2) {
                            Variable variable = data.getEnvironment().lookup(tokens[0].toString());
                            objectExpType = (EClassifier)variable.getType();
                        } else {
                            typeTokens = new IToken[tokens.length - 2];
                            System.arraycopy(tokens, 2, typeTokens, 0, typeTokens.length);
                        }
                    } else {
                        typeTokens = tokens;
                    }
                }
            }
        }
        if (typeTokens != null && (oclExpression = LightweightParserUtil.getOclExpression(typeTokens, data, LightweightParserUtil.ParserTypeEnum.LIGHTWEIGHT_TYPE_PARSER)) instanceof TypeExp) {
            TypeExp typeExp = (TypeExp)oclExpression;
            objectExpType = (EClassifier)typeExp.getReferredType();
        }
        if (objectExpType != null) {
            CompletionProposalUtil.addStructuralFeatures(proposals, objectExpType, data);
        }
        if (QvtCompletionData.isKindOf(structuralFeatureContainerToken, 89)) {
            CompletionProposalUtil.addKeywords(proposals, new int[]{133, 47, 88}, data);
        }
    }

    private static IToken[] extractMappingType(IToken mappingToken) {
        IToken rParen;
        IToken lParen = LightweightParserUtil.getNextTokenByKind(mappingToken, 2);
        if (lParen != null && (rParen = LightweightParserUtil.getPairingBrace(lParen, true)) != null) {
            IToken colon = LightweightParserUtil.getNextToken(rParen);
            if (colon != null && colon.getKind() == 63) {
                IToken firstTypeToken = LightweightParserUtil.getNextToken(colon);
                if (firstTypeToken != null) {
                    return QvtCompletionData.extractTokens(firstTypeToken, QvtCompletionData.MAPPING_DECLARATION_TRAILING_TOKEN_KINDS);
                }
            } else {
                IToken prevToken;
                IToken token = lParen;
                IToken lastColoncolon = null;
                while ((prevToken = LightweightParserUtil.getPreviousToken(token)) != null && !QvtCompletionData.isKindOf(prevToken, 89)) {
                    if (QvtCompletionData.isKindOf(prevToken, 65)) {
                        lastColoncolon = prevToken;
                    }
                    if (QvtCompletionData.isKindOf(prevToken, 99) && lastColoncolon != null) {
                        IPrsStream prsStream = token.getIPrsStream();
                        IToken[] tokenArray = new IToken[lastColoncolon.getTokenIndex() - token.getTokenIndex()];
                        int i = token.getTokenIndex();
                        while (i < lastColoncolon.getTokenIndex()) {
                            tokenArray[i - token.getTokenIndex()] = prsStream.getTokenAt(i);
                            ++i;
                        }
                        return tokenArray;
                    }
                    token = prevToken;
                }
            }
        }
        return null;
    }
}

